/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigFlatOptionKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOption;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueIdentifier;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigSection;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.ui.EditorNotifications;
import java.util.HashSet;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingCharsetUtil;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

final class EditorConfigStatusListener
implements CodeStyleSettingsListener {
    private boolean myEnabledStatus;
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private Set<String> myEncodings;

    EditorConfigStatusListener(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Set<String> encodings) {
        if (project == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(1);
        }
        if (encodings == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myEnabledStatus = Utils.isEnabled(project);
        this.myVirtualFile = virtualFile;
        this.myEncodings = encodings;
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        Set<String> newEncodings;
        CodeStyleSettings settings;
        if (event == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(3);
        }
        if ((settings = CodeStyle.getSettings((Project)this.myProject)).getCustomSettingsIfCreated(EditorConfigSettings.class) == null) {
            return;
        }
        boolean newEnabledStatus = Utils.isEnabled(this.myProject);
        if (this.myEnabledStatus != newEnabledStatus) {
            this.myEnabledStatus = newEnabledStatus;
            this.onEditorConfigEnabled(newEnabledStatus);
        }
        if (!this.myEncodings.equals(newEncodings = EditorConfigStatusListener.extractEncodings(this.myProject, this.myVirtualFile))) {
            if (EditorConfigStatusListener.containsValidEncodings(newEncodings)) {
                EditorConfigStatusListener.onEncodingChanged();
            }
            this.myEncodings = newEncodings;
        }
    }

    private void onEditorConfigEnabled(boolean isEnabled) {
        PsiFile psiFile;
        if (!isEnabled) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            fileEditorManager.closeFile(this.myVirtualFile);
            fileEditorManager.openFile(this.myVirtualFile, false);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        PsiFile psiFile2 = psiFile = document == null ? null : PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile, (Object)this);
        }
    }

    private static void onEncodingChanged() {
        EditorConfigEncodingCache.Companion.getInstance().reset();
    }

    private static boolean containsValidEncodings(@NotNull Set<String> encodings) {
        if (encodings == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(4);
        }
        for (String t : encodings) {
            if (ConfigEncodingCharsetUtil.INSTANCE.toCharset(t) != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    static Set<String> extractEncodings(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(5);
        }
        if (file == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(6);
        }
        final HashSet<String> charsets = new HashSet<String>();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            HashSet<String> hashSet = charsets;
            if (hashSet == null) {
                EditorConfigStatusListener.$$$reportNull$$$0(7);
            }
            return hashSet;
        }
        PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiFile || element instanceof EditorConfigSection) {
                    super.visitElement(element);
                } else if (element instanceof EditorConfigOption) {
                    String keyName;
                    EditorConfigFlatOptionKey obj1 = ((EditorConfigOption)element).getFlatOptionKey();
                    String string = keyName = obj1 == null ? null : obj1.getName();
                    if ("charset".equals(keyName)) {
                        String charsetStr;
                        EditorConfigOptionValueIdentifier obj = ((EditorConfigOption)element).getOptionValueIdentifier();
                        String string2 = charsetStr = obj == null ? null : obj.getName();
                        if (charsetStr != null) {
                            charsets.add(charsetStr);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/editorconfig/configmanagement/editor/EditorConfigStatusListener$1", "visitElement"));
            }
        };
        psiFile.accept((PsiElementVisitor)visitor2);
        HashSet<String> hashSet = charsets;
        if (hashSet == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractEncodings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsValidEncodings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractEncodings";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

