﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloud9/Cloud9_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Cloud9 {
namespace Model {

/**
 * <p>Metadata that is associated with Amazon Web Services resources. In
 * particular, a name-value pair that can be associated with an Cloud9 development
 * environment. There are two types of tags: <i>user tags</i> and <i>system
 * tags</i>. A user tag is created by the user. A system tag is automatically
 * created by Amazon Web Services services. A system tag is prefixed with
 * <code>"aws:"</code> and cannot be modified by the user.</p><p><h3>See Also:</h3>
 * <a href="http://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/Tag">AWS API
 * Reference</a></p>
 */
class Tag {
 public:
  AWS_CLOUD9_API Tag() = default;
  AWS_CLOUD9_API Tag(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUD9_API Tag& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUD9_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <b>name</b> part of a tag.</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  Tag& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <b>value</b> part of a tag.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  Tag& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;

  Aws::String m_value;
  bool m_keyHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace Cloud9
}  // namespace Aws
