/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import java.awt.Color;
import java.io.Serializable;

public class HSBColor
implements Serializable,
Cloneable {
    protected double m_hue;
    protected double m_lum;
    protected double m_sat;
    protected double m_alpha;

    public static HSBColor rgbToHSB(Color color) {
        int cmax;
        int rgb = color.getRGB();
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        HSBColor ret = new HSBColor();
        int n = r >= g ? (r >= b ? r : b) : (cmax = g >= b ? g : b);
        int cmin = r <= g ? (r <= b ? r : b) : (g <= b ? g : b);
        ret.m_lum = (float)cmax / 255.0f;
        if (cmax != cmin) {
            float difference = cmax - cmin;
            ret.m_sat = difference / (float)cmax;
            ret.m_hue = r == cmax ? (double)((float)(g - b) / difference) : (g == cmax ? (double)((float)(b - r) / difference + 2.0f) : (double)((float)(r - g) / difference + 4.0f));
            ret.m_hue /= 6.0;
            if (ret.m_hue < 0.0) {
                ret.m_hue += 1.0;
            }
        } else {
            ret.m_sat = 0.0;
            ret.m_hue = 0.0;
        }
        ret.m_alpha = color.getAlpha();
        return ret;
    }

    private HSBColor() {
    }

    HSBColor(double hue, double saturation, double brightness, int alpha) {
        this.m_hue = hue;
        this.m_sat = saturation;
        this.m_lum = brightness;
        this.m_alpha = alpha;
    }

    public Object clone() {
        HSBColor result = null;
        try {
            result = (HSBColor)super.clone();
            result.m_hue = this.m_hue;
            result.m_lum = this.m_lum;
            result.m_sat = this.m_sat;
            result.m_alpha = this.m_alpha;
        }
        catch (CloneNotSupportedException e) {
            result = new HSBColor((float)this.m_hue, (float)this.m_sat, (float)this.m_lum, (int)Math.round(this.m_alpha));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HSBColor)) {
            return false;
        }
        HSBColor other = (HSBColor)o;
        return this.m_hue == other.m_hue && this.m_sat == other.m_sat && this.m_lum == other.m_lum && this.m_alpha == other.m_alpha;
    }

    public Color getRGBColor() {
        int rgb = Color.HSBtoRGB((float)this.m_hue, (float)this.m_sat, (float)this.m_lum);
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return new Color(r, g, b, (int)Math.round(this.m_alpha));
    }

    public int hashCode() {
        return (int)(this.m_hue * 10000.0 + this.m_sat * 1000.0 + this.m_lum * 100.0);
    }
}

