/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.LabourData;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;

public final class CompactLabourReport
extends ReportPanel {
    private static final int COLONY_COLUMN = 0;
    private static final int UNIT_TYPE_COLUMN = 1;
    private static final int WORKING_COLUMN = 2;
    private static final int BUILDING_COLUMN = 3;
    private static final int COLONIST_COLUMN = 4;
    private static final int COLONIST_SUMMARY_COLUMN = 5;
    private static final int PRODUCTION_SYMBOL_COLUMN = 6;
    private static final int PRODUCTION_COLUMN = 7;
    private static final int PRODUCTION_SUMMARY_COLUMN = 8;
    private static final int NETPRODUCTION_SUMMARY_COLUMN = 9;
    private static final int COLUMNS = 10;
    private LabourData labourData;
    private final LabourData.UnitData unitData;
    private boolean showProduction;
    private boolean showNetProduction;
    private boolean showProductionSymbols;
    private boolean showBuildings;
    private final JPanel headerRow = new MigPanel("ReportPanelUI");

    public CompactLabourReport(FreeColClient freeColClient) {
        this(freeColClient, (LabourData.UnitData)null);
        this.labourData = new LabourData(this.getFreeColClient());
    }

    public CompactLabourReport(FreeColClient freeColClient, LabourData.UnitData data) {
        super(freeColClient, data == null ? "reportLabourAction" : "report.labour.details");
        this.unitData = data;
        this.headerRow.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.headerRow.setOpaque(true);
        this.scrollPane.setColumnHeaderView(this.headerRow);
    }

    @Override
    public JButton createColonyButton(Colony colony) {
        Object text = colony.getName();
        if (!this.unitData.isSummary() && colony.canTrain(this.unitData.getUnitType())) {
            text = (String)text + "*";
        }
        return this.createButton((String)text, ae -> this.getGUI().showColonyPanel(colony, null));
    }

    @Override
    public void initialize() {
        if (this.isOverview()) {
            this.showProduction = true;
            this.showNetProduction = true;
            this.showProductionSymbols = true;
            this.showBuildings = false;
        } else {
            this.showProduction = this.unitData.showProduction();
            this.showNetProduction = this.unitData.showNetProduction();
            this.showProductionSymbols = false;
            GoodsType expertProduction = this.getGoodsType();
            this.showBuildings = expertProduction != null && !expertProduction.isFarmed() || this.unitData.getTotal().isTraining();
        }
        String layoutConstraints = "fill, insets 0, gap 0 0";
        StringBuilder widths = new StringBuilder();
        widths.append("[175, fill]");
        widths.append(this.isOverview() || !this.unitData.isSummary() ? "[150, fill]" : "[0!]");
        widths.append("[150, fill]");
        widths.append(this.showBuildings ? "[130, fill]" : "[0!]");
        widths.append("[26, fill][33, fill]");
        widths.append(this.showProductionSymbols ? "[50, fill]" : "[0!]");
        widths.append(this.showProduction ? "[30, fill][40, fill]" : "[0!][0!]");
        widths.append(this.showNetProduction ? "[40, fill]" : "[0!]");
        String columnConstraints = widths.toString();
        String rowConstraints = "[fill]";
        this.headerRow.setLayout(new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        this.reportPanel.setLayout(new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        this.addHeader();
        if (this.isOverview()) {
            this.addUnitTypes();
        } else {
            this.addLocations();
        }
    }

    private void addHeader() {
        JLabel empty = new JLabel();
        empty.setBorder(Utility.getTopLeftCellBorder());
        this.headerRow.add((Component)empty, "cell 0 1");
        if (this.isOverview() || !this.unitData.isSummary()) {
            JLabel unitType = Utility.localizedLabel("unitType");
            unitType.setBorder(Utility.getTopCellBorder());
            this.headerRow.add((Component)unitType, "cell 1 1");
        }
        JLabel workingAs = Utility.localizedLabel("report.labour.workingAs");
        workingAs.setBorder(Utility.getTopCellBorder());
        this.headerRow.add((Component)workingAs, "cell 2 1");
        if (this.showBuildings) {
            JLabel building = Utility.localizedLabel("building");
            building.setBorder(Utility.getTopCellBorder());
            this.headerRow.add((Component)building, "cell 3 1");
        }
        JLabel colonists = Utility.localizedLabel("colonists");
        colonists.setBorder(Utility.getTopCellBorder());
        this.headerRow.add((Component)colonists, "cell 4 1 2 1");
        if (this.isOverview()) {
            JLabel production = Utility.localizedLabel("report.labour.production");
            production.setBorder(Utility.getTopCellBorder());
            this.headerRow.add((Component)production, "cell 6 1 4 1");
        } else if (this.showProduction) {
            LabourData.UnitData unit = this.unitData;
            GoodsType goodsType = unit.getExpertProduction();
            ImageLibrary lib = this.getImageLibrary();
            JLabel production = new JLabel(new ImageIcon(lib.getScaledGoodsTypeImage(goodsType)));
            production.setBorder(Utility.getTopCellBorder());
            this.headerRow.add((Component)production, "cell 6 1 " + (4 + (this.showNetProduction && goodsType.isStoredAs() ? 1 : 0)) + " 1");
            if (this.showNetProduction && goodsType.isStoredAs()) {
                JLabel netProduction = new JLabel(new ImageIcon(lib.getScaledGoodsTypeImage(goodsType.getStoredAs())));
                netProduction.setBorder(Utility.getTopCellBorder());
                this.headerRow.add((Component)netProduction, "cell 9 1");
            }
        }
        if (!this.isSummary()) {
            ImageIcon icon = new ImageIcon(this.getImageLibrary().getScaledUnitTypeImage(this.unitData.getUnitType()));
            this.header.setIcon(icon);
            this.header.setIconTextGap(20);
        }
    }

    private int addLocationData(LabourData.LocationData data, Colony colony, int row) {
        int studentCount;
        WorkLocation school;
        boolean allColonists = data.getUnitData().isSummary();
        LabourData.UnitData unit = data.getUnitData();
        UnitType unitType = unit.getUnitType();
        String unitName = unit.getUnitName();
        String workingAs = null;
        WorkLocation productionWL = null;
        if (!allColonists) {
            GoodsType expert;
            workingAs = Messages.message(unitType.getWorkingAsKey());
            if (colony != null && (expert = unitType.getExpertProduction()) != null) {
                productionWL = colony.getWorkLocationForProducing(expert);
            }
        }
        this.addLocationSummary(data, row);
        int buildingStartRow = row;
        int otherAmateurs = data.getOtherWorkingAmateurs().getColonists();
        if (!allColonists && otherAmateurs > 0) {
            this.addRow(data, Messages.message("report.labour.otherUnitType"), workingAs, this.createNonCountedLabel(otherAmateurs), data.getOtherWorkingAmateurs().getProduction(), row);
            ++row;
        }
        int notProducingStartRow = row = this.addRow(data, unitName, allColonists ? Messages.message("report.labour.expertsWorking") : workingAs, data.getWorkingProfessionals().getColonists(), data.getWorkingProfessionals().getProduction(), row);
        if (this.showBuildings) {
            if (productionWL != null && row > buildingStartRow) {
                JLabel buildingLabel = Utility.localizedLabel(productionWL.getLabel());
                buildingLabel.setBorder(Utility.getCellBorder());
                this.reportPanel.add((Component)buildingLabel, "cell 3 " + buildingStartRow + " 1 " + (row - buildingStartRow));
                buildingStartRow = row;
            } else {
                this.reportPanel.add((Component)this.createEmptyLabel(), "cell 3 " + buildingStartRow + " 1 " + (row - buildingStartRow));
            }
        }
        row = this.addRow(data, unitName, Messages.message(allColonists ? "report.labour.amateursWorking" : "report.labour.workingAsOther"), data.getWorkingAmateurs(), 0, row);
        if (data.getNotWorking() > 0) {
            this.addRow(data, unitName, Messages.message("report.labour.notWorking"), this.createNumberLabel(data.getNotWorking(), "report.labour.notWorking.tooltip"), 0, row);
            ++row;
        }
        WorkLocation workLocation = school = colony != null && data.isTraining() ? colony.getWorkLocationWithAbility("model.ability.teach") : null;
        if (this.showBuildings && school != null && row > buildingStartRow) {
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell 3 " + buildingStartRow + " 1 " + (row - buildingStartRow));
            buildingStartRow = row;
        }
        row = this.addRow(data, unitName, Messages.message("report.labour.teacher"), data.getTeachers(), 0, row);
        if (!allColonists) {
            row = this.addRow(data, data.getOtherStudentsName(), Messages.message(StringTemplate.template("report.labour.learning").addName("%unit%", data.getUnitData().getUnitName())), data.getOtherStudents(), 0, row);
        }
        if ((studentCount = data.getStudents()) > 0) {
            if (allColonists) {
                this.addRow(data, null, Messages.message("report.labour.sutdent"), this.createNonCountedLabel(studentCount), 0, row);
            } else {
                Predicate<Unit> teachingPred = u -> {
                    Unit student = u.getStudent();
                    return student != null && student.getType() == unitType;
                };
                Function<Unit, UnitType> studentMapper = u -> unitType.getTeachingType(u.getType());
                Set resultOfTraining = colony == null ? Collections.emptySet() : CollectionUtils.transform(colony.getTeachers(), teachingPred, studentMapper, Collectors.toSet());
                String student = resultOfTraining.size() == 1 ? Messages.message(StringTemplate.template("report.labour.learning").addName("%unit%", (FreeColObject)CollectionUtils.first(resultOfTraining))) : Messages.message("report.labour.learningOther");
                this.addRow(data, data.getUnitData().getUnitName(), student, this.createNumberLabel(-studentCount, "report.labour.subtracted.tooltip"), 0, row);
            }
            ++row;
        }
        if (this.showBuildings && row > buildingStartRow) {
            JLabel buildingLabel = new JLabel(school == null ? "" : Messages.message(school.getLabel()));
            buildingLabel.setBorder(Utility.getCellBorder());
            this.reportPanel.add((Component)buildingLabel, "cell 3 " + buildingStartRow + " 1 " + (row - buildingStartRow));
        }
        if (row > notProducingStartRow && data.getUnitData().showProduction()) {
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell 7 " + notProducingStartRow + " 1 " + (row - notProducingStartRow));
        }
        return row;
    }

    private void addLocations() {
        Player player = this.getMyPlayer();
        LabourData.LocationData unitTotal = this.unitData.getTotal();
        int row = 1;
        JLabel summaryLabel = Utility.localizedLabel("report.labour.summary");
        summaryLabel.setBorder(Utility.getLeftCellBorder());
        this.reportPanel.add((Component)summaryLabel, "cell 0 " + row + " 1 " + unitTotal.getRowCount());
        row = this.addLocationData(unitTotal, null, row);
        for (Colony colony : player.getColonyList()) {
            LabourData.LocationData colonyData = this.unitData.getDetails().get(colony);
            if (colonyData == null) continue;
            this.reportPanel.add((Component)this.createColonyButton(colony), "cell 0 " + row + " 1 " + colonyData.getRowCount());
            row = this.addLocationData(colonyData, colony, row);
        }
        LabourData.LocationData europe = this.unitData.getUnitsInEurope();
        int euRow = europe.getRowCount();
        if (euRow > 0) {
            String nam = Messages.getName(this.getMyPlayer().getEurope());
            JButton button = this.createButton(nam, ae -> this.getGUI().showEuropePanel());
            this.reportPanel.add((Component)button, "cell 0 " + row + " 1 " + euRow);
            row = this.addLocationData(europe, null, row);
        }
        row = this.addNonLinkedLocation(this.unitData.getUnitsOnLand(), "report.labour.onLand", row);
        row = this.addNonLinkedLocation(this.unitData.getUnitsAtSea(), "report.labour.atSea", row);
        this.reportPanel.add((Component)Utility.localizedLabel("report.labour.canTrain"), "cell 1 " + row + " 10 1");
    }

    private void addLocationSummary(LabourData.LocationData data, int row) {
        int rows = data.getRowCount();
        JLabel colonistsLabel = this.createNumberLabel(data.getTotalColonists(), null);
        if (data.getUnitData().isSummary()) {
            if (this.isOverview()) {
                this.reportPanel.add((Component)this.createEmptyLabel(), "cell 1 " + row + " 1 " + rows);
            }
        } else {
            Utility.localizeToolTip((JComponent)colonistsLabel, StringTemplate.template("report.labour.unitTotal.tooltip").addName("%unit%", data.getUnitData().getUnitName()));
        }
        this.reportPanel.add((Component)colonistsLabel, "cell 5 " + row + " 1 " + data.getRowCount());
        if (this.showProduction && !data.getUnitData().showProduction()) {
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell 6 " + row + " 4 " + rows);
            return;
        }
        if (this.showProduction) {
            JLabel productionLabel = this.createNumberLabel(data.getTotalProduction(), "report.labour.potentialProduction.tooltip");
            if (!data.isTotal() && data.getTotalProduction() == 0) {
                productionLabel.setText("");
            }
            this.reportPanel.add((Component)productionLabel, "cell 8 " + row + " 1 " + rows);
        }
        if (this.showNetProduction) {
            int net = data.getNetProduction();
            JLabel netProductionLabel = this.createNumberLabel(net, "report.labour.netProduction.tooltip");
            if (!data.getUnitData().showNetProduction() || !data.isTotal() && net == 0) {
                netProductionLabel.setText("");
                netProductionLabel.setToolTipText("");
            } else if (net >= 0) {
                netProductionLabel.setText("+" + net);
            } else {
                netProductionLabel.setForeground(Color.RED);
            }
            this.reportPanel.add((Component)netProductionLabel, "cell 9 " + row + " 1 " + rows);
        }
        if (this.showProductionSymbols) {
            JLabel icon = new JLabel();
            icon.setBorder(Utility.getCellBorder());
            GoodsType goodsType = data.getUnitData().getExpertProduction();
            if (goodsType != null) {
                icon.setIcon(new ImageIcon(this.getImageLibrary().getScaledGoodsTypeImage(goodsType)));
            }
            this.reportPanel.add((Component)icon, "cell 6 " + row + " 1 " + rows);
        }
    }

    private int addNonLinkedLocation(LabourData.LocationData data, String messageKey, int row) {
        int rows = data.getRowCount();
        if (rows <= 0) {
            return row;
        }
        JLabel label = Utility.localizedLabel(messageKey);
        label.setBorder(Utility.getLeftCellBorder());
        label.setForeground(Color.GRAY);
        this.reportPanel.add((Component)label, "cell 0 " + row + " 1 " + rows);
        return this.addLocationData(data, null, row);
    }

    private int addRow(LabourData.LocationData data, String typeName, String activity, int colonists, int production, int row) {
        if (colonists > 0) {
            this.addRow(data, typeName, activity, this.createNumberLabel(colonists, null), production, row);
            ++row;
        }
        return row;
    }

    private void addRow(LabourData.LocationData data, String typeName, String activity, JLabel colonistLabel, int production, int row) {
        if (!data.getUnitData().isSummary()) {
            JLabel typeLabel = new JLabel(typeName);
            typeLabel.setBorder(Utility.getCellBorder());
            this.reportPanel.add((Component)typeLabel, "cell 1 " + row);
        }
        JLabel activityLabel = new JLabel(activity);
        activityLabel.setBorder(Utility.getCellBorder());
        this.reportPanel.add((Component)activityLabel, "cell 2 " + row);
        this.reportPanel.add((Component)colonistLabel, "cell 4 " + row);
        if (production > 0 && data.getUnitData().showProduction()) {
            this.reportPanel.add((Component)this.createNumberLabel(production, "report.labour.potentialProduction.tooltip"), "cell 7 " + row);
        }
    }

    private void addUnitTypes() {
        int row = 1;
        JButton allColonistsButton = this.createUnitNameButton(Messages.message("report.labour.allColonists"), this.labourData.getSummary());
        this.reportPanel.add((Component)allColonistsButton, "cell 0 " + row + " 1 " + this.labourData.getSummary().getUnitSummaryRowCount());
        row = this.addLocationData(this.labourData.getSummary().getTotal(), null, row);
        for (UnitType unitType : LabourData.getLabourTypes(this.getMyPlayer())) {
            LabourData.UnitData unitData = this.labourData.getUnitData(unitType);
            JButton unitButton = this.createUnitNameButton(unitData.getUnitName(), unitData);
            int rows = unitData.getUnitSummaryRowCount();
            this.reportPanel.add((Component)unitButton, "cell 0 " + row + " 1 " + rows);
            if (unitData.hasDetails()) {
                row = this.addLocationData(unitData.getTotal(), null, row);
                continue;
            }
            unitButton.setEnabled(false);
            unitButton.setDisabledIcon(unitButton.getIcon());
            unitButton.setForeground(Color.GRAY);
            this.reportPanel.add((Component)this.createEmptyLabel(), "cell 1 " + row + " 9 1");
            ++row;
        }
    }

    private JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setOpaque(false);
        button.setHorizontalAlignment(10);
        button.setForeground(Utility.getLinkColor());
        button.setBorder(Utility.getLeftCellBorder());
        button.addActionListener(listener);
        return button;
    }

    private JLabel createEmptyLabel() {
        JLabel empty = new JLabel();
        empty.setBorder(Utility.getCellBorder());
        return empty;
    }

    private JLabel createNonCountedLabel(int otherAmateurs) {
        JLabel label = this.createNumberLabel(otherAmateurs, "report.labour.notCounted.tooltip");
        label.setForeground(Color.GRAY);
        return label;
    }

    private JLabel createNumberLabel(int number, String toolTipKey) {
        JLabel label = new JLabel(String.valueOf(number));
        label.setHorizontalAlignment(11);
        label.setBorder(Utility.getCellBorder());
        if (toolTipKey != null) {
            Utility.localizeToolTip((JComponent)this, toolTipKey);
        }
        return label;
    }

    private JButton createUnitNameButton(String name, LabourData.UnitData unitData) {
        JButton button = this.createButton(name, ae -> this.getGUI().showCompactLabourReport(unitData));
        if (!unitData.isSummary()) {
            button.setIcon(new ImageIcon(this.getImageLibrary().getScaledUnitTypeImage(unitData.getUnitType())));
        }
        return button;
    }

    private GoodsType getGoodsType() {
        return this.isSummary() ? null : this.unitData.getUnitType().getExpertProduction();
    }

    private boolean isOverview() {
        return this.unitData == null;
    }

    private boolean isSummary() {
        return this.isOverview() || this.unitData.isSummary();
    }
}

