/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.util.List;
import tim.prune.data.Bearing;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Timestamp;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.PointUtils;
import tim.prune.function.comparesegments.IntersectionResult;
import tim.prune.function.comparesegments.LineAndBearing;
import tim.prune.function.comparesegments.PointData;

public class SegmentLooper {
    private final List<LineAndBearing> _lines;
    private int _currentLine = 0;
    private static final double BEARING_TOLERANCE_DEGREES = 20.0;
    private static final double DISTANCE_TOLERANCE_RADIANS = Distance.convertDistanceToRadians(25.0, UnitSetLibrary.UNITS_METRES);
    private static final double NO_MATCH_FOUND = -1.0;

    public SegmentLooper(List<LineAndBearing> list) {
        this._lines = list;
    }

    public IntersectionResult match(PointData pointData) {
        int n = this._currentLine;
        while (n < this._lines.size()) {
            IntersectionResult intersectionResult = this.matchFound(pointData, this._lines.get(n));
            if (intersectionResult != null) {
                this._currentLine = n;
                return intersectionResult;
            }
            ++n;
        }
        return null;
    }

    private IntersectionResult matchFound(PointData pointData, LineAndBearing lineAndBearing) {
        double d = Bearing.angleDifferenceDegrees(pointData._bearing, lineAndBearing._bearing);
        if (d >= 20.0) {
            return null;
        }
        DataPoint dataPoint = PointUtils.projectPoint(pointData._point, Math.toRadians(pointData._bearing + 90.0), DISTANCE_TOLERANCE_RADIANS);
        DataPoint dataPoint2 = PointUtils.projectPoint(pointData._point, Math.toRadians(pointData._bearing - 90.0), DISTANCE_TOLERANCE_RADIANS);
        DataPoint dataPoint3 = lineAndBearing.getFromPoint();
        DataPoint dataPoint4 = lineAndBearing.getToPoint();
        if (!SegmentLooper.overlap(dataPoint2.getLongitude(), dataPoint.getLongitude(), dataPoint3.getLongitude(), dataPoint4.getLongitude()) || !SegmentLooper.overlap(dataPoint2.getLatitude(), dataPoint.getLatitude(), dataPoint3.getLatitude(), dataPoint4.getLatitude())) {
            return null;
        }
        double d2 = SegmentLooper.calculateLineFraction(dataPoint2, dataPoint, dataPoint3, dataPoint4);
        if (d2 < 0.0 || d2 > 1.0) {
            return null;
        }
        long l = lineAndBearing.getMilliseconds();
        Timestamp timestamp = dataPoint3.getTimestamp().addOffsetMilliseconds((long)((double)l * d2));
        double d3 = lineAndBearing._distToFromPointRadians + d2 * lineAndBearing._distAlongRadians;
        double d4 = pointData._speedRadiansPerSec;
        double d5 = lineAndBearing.getInterpolatedSpeed(d2);
        DataPoint dataPoint5 = PointUtils.interpolate(dataPoint3, dataPoint4, d2);
        return new IntersectionResult(pointData._point, dataPoint5, pointData._point.getTimestamp(), timestamp, pointData._distanceToHereRadians, d3, d4, d5);
    }

    public static double calculateLineFraction(DataPoint dataPoint, DataPoint dataPoint2, DataPoint dataPoint3, DataPoint dataPoint4) {
        double d = dataPoint.getLongitude().getDouble();
        double d2 = dataPoint2.getLongitude().getDouble();
        double d3 = dataPoint.getLatitude().getDouble();
        double d4 = dataPoint2.getLatitude().getDouble();
        double d5 = dataPoint3.getLongitude().getDouble();
        double d6 = dataPoint4.getLongitude().getDouble();
        double d7 = dataPoint3.getLatitude().getDouble();
        double d8 = dataPoint4.getLatitude().getDouble();
        if (SegmentLooper.isNearlyZero(d2 - d)) {
            if (SegmentLooper.isNearlyZero(d6 - d5)) {
                return -1.0;
            }
            return SegmentLooper.checkWithinRange((d - d5) / (d6 - d5));
        }
        if (SegmentLooper.isNearlyZero(d4 - d3)) {
            if (SegmentLooper.isNearlyZero(d8 - d7)) {
                return -1.0;
            }
            return SegmentLooper.checkWithinRange((d3 - d7) / (d8 - d7));
        }
        double d9 = (d5 - d) / (d2 - d);
        double d10 = (d6 - d5) / (d2 - d);
        double d11 = d10 * (d4 - d3) + d7 - d8;
        if (SegmentLooper.isNearlyZero(d11)) {
            return -1.0;
        }
        double d12 = (d7 - d3 - d9 * (d4 - d3)) / d11;
        double d13 = d9 + d12 * d10;
        if (SegmentLooper.checkWithinRange(d13) >= 0.0) {
            return SegmentLooper.checkWithinRange(d12);
        }
        return -1.0;
    }

    private static boolean isNearlyZero(double d) {
        return Math.abs(d) < 1.0E-10;
    }

    private static double checkWithinRange(double d) {
        if (d < 0.0 || d > 1.0) {
            return -1.0;
        }
        return d;
    }

    private static boolean overlap(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        if (Math.abs(coordinate.getDouble() - coordinate2.getDouble()) > 1.0 || Math.abs(coordinate3.getDouble() - coordinate4.getDouble()) > 1.0) {
            return false;
        }
        double d = Math.min(coordinate.getDouble(), coordinate2.getDouble());
        double d2 = Math.max(coordinate.getDouble(), coordinate2.getDouble());
        double d3 = Math.min(coordinate3.getDouble(), coordinate4.getDouble());
        double d4 = Math.max(coordinate3.getDouble(), coordinate4.getDouble());
        return d4 >= d && d2 >= d3;
    }
}

