/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultScalaSourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.scala.ScalaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.internal.ReportUtilities;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.api.tasks.scala.internal.ScalaRuntimeHelper;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.language.scala.tasks.KeepAliveMode;

public abstract class ScalaBasePlugin
implements Plugin<Project> {
    public static final String DEFAULT_ZINC_VERSION = "1.10.4";
    private static final String DEFAULT_SCALA_ZINC_VERSION = "2.13";
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    public static final String SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME = "scalaCompilerPlugins";
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;
    private final DependencyFactory dependencyFactory;

    @Inject
    public ScalaBasePlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices, DependencyFactory dependencyFactory) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
        this.dependencyFactory = dependencyFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        ScalaRuntime scalaRuntime = (ScalaRuntime)project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, new Object[]{project});
        ScalaPluginExtension scalaPluginExtension = (ScalaPluginExtension)project.getExtensions().create("scala", ScalaPluginExtension.class, new Object[0]);
        scalaPluginExtension.getZincVersion().convention((Object)DEFAULT_ZINC_VERSION);
        Provider<ResolvableConfiguration> toolchainClasspath = this.createToolchainRuntimeClasspath(project, scalaPluginExtension);
        Usage incrementalAnalysisUsage = (Usage)this.objectFactory.named(Usage.class, "incremental-analysis");
        Category incrementalAnalysisCategory = (Category)this.objectFactory.named(Category.class, "scala-analysis");
        this.configureConfigurations((ProjectInternal)project, incrementalAnalysisCategory, incrementalAnalysisUsage, scalaPluginExtension);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime, (DefaultJavaPluginExtension)ScalaBasePlugin.javaPluginExtension(project), scalaPluginExtension, toolchainClasspath);
        this.configureSourceSetDefaults((ProjectInternal)project, incrementalAnalysisCategory, incrementalAnalysisUsage, scalaPluginExtension);
        ScalaBasePlugin.configureScaladoc(project, scalaRuntime, scalaPluginExtension, toolchainClasspath);
    }

    private void configureConfigurations(ProjectInternal project, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage, ScalaPluginExtension scalaPluginExtension) {
        DependencyHandler dependencyHandler = project.getDependencies();
        project.getConfigurations().resolvableDependencyScopeLocked(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME, plugins -> {
            plugins.setTransitive(false);
            this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)plugins);
        });
        project.getConfigurations().resolvableDependencyScopeLocked(ZINC_CONFIGURATION_NAME, zinc -> {
            zinc.setDescription("The Zinc incremental compiler to be used for this Scala project.");
            zinc.getResolutionStrategy().eachDependency(rule -> {
                if (rule.getRequested().getGroup().equals("com.typesafe.zinc") && rule.getRequested().getName().equals(ZINC_CONFIGURATION_NAME)) {
                    rule.useTarget((Object)"org.scala-sbt:zinc_2.13:1.10.4");
                    rule.because("Typesafe Zinc is no longer maintained.");
                }
            });
            zinc.defaultDependencies(dependencies -> {
                dependencies.add((Object)dependencyHandler.create((Object)("org.scala-sbt:zinc_2.13:" + (String)scalaPluginExtension.getZincVersion().get())));
                zinc.getIncoming().afterResolve(resolvableDependencies -> resolvableDependencies.getResolutionResult().allComponents(component -> {
                    if (component.getModuleVersion() != null && component.getModuleVersion().getName().equals("scala-library") && !component.getModuleVersion().getVersion().startsWith(DEFAULT_SCALA_ZINC_VERSION)) {
                        throw new InvalidUserCodeException("The version of 'scala-library' was changed while using the default Zinc version. Version " + component.getModuleVersion().getVersion() + " is not compatible with org.scala-sbt:zinc_" + DEFAULT_SCALA_ZINC_VERSION + ":" + DEFAULT_ZINC_VERSION);
                    }
                }));
            });
            zinc.getDependencyConstraints().add((Object)dependencyHandler.getConstraints().create((Object)"org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
                version.require("2.17.1");
                version.reject(new String[]{"[2.0, 2.17.1)"});
            })));
        });
        project.getConfigurations().consumable("incrementalScalaAnalysisElements", incrementalAnalysisElements -> {
            incrementalAnalysisElements.setDescription("Incremental compilation analysis files");
            incrementalAnalysisElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)incrementalAnalysisUsage);
            incrementalAnalysisElements.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)incrementalAnalysisCategory);
        });
        AttributeMatchingStrategy matchingStrategy = dependencyHandler.getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, actionConfiguration -> {
            actionConfiguration.params(new Object[]{incrementalAnalysisUsage});
            actionConfiguration.params(new Object[]{this.objectFactory.named(Usage.class, "java-api")});
            actionConfiguration.params(new Object[]{this.objectFactory.named(Usage.class, "java-runtime")});
        });
    }

    private Provider<ResolvableConfiguration> createToolchainRuntimeClasspath(Project project, ScalaPluginExtension scalaPluginExtension) {
        NamedDomainObjectProvider scalaToolchain = project.getConfigurations().dependencyScope("scalaToolchain", conf -> {
            conf.setDescription("Dependencies for the Scala toolchain");
            conf.getDependencies().addLater(this.createScalaCompilerDependency(scalaPluginExtension));
            conf.getDependencies().addLater(this.createScalaBridgeDependency(scalaPluginExtension));
            conf.getDependencies().addLater(this.createScalaCompilerInterfaceDependency(scalaPluginExtension));
            conf.getDependencies().addLater(this.createScaladocDependency(scalaPluginExtension));
        });
        return project.getConfigurations().resolvable("scalaToolchainRuntimeClasspath", arg_0 -> this.lambda$createToolchainRuntimeClasspath$11((Provider)scalaToolchain, arg_0));
    }

    private void configureSourceSetDefaults(ProjectInternal project, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage, ScalaPluginExtension scalaPluginExtension) {
        ScalaBasePlugin.javaPluginExtension((Project)project).getSourceSets().all(sourceSet -> {
            ScalaSourceDirectorySet scalaSource = this.createScalaSourceDirectorySet((SourceSet)sourceSet);
            sourceSet.getExtensions().add(ScalaSourceDirectorySet.class, "scala", (Object)scalaSource);
            scalaSource.srcDir(project.file((Object)("src/" + sourceSet.getName() + "/scala")));
            ScalaSourceDirectorySet scalaSourceFiles = scalaSource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(arg_0 -> ScalaBasePlugin.lambda$configureSourceSetDefaults$17be3d40$1((FileCollection)scalaSourceFiles, arg_0)));
            sourceSet.getAllJava().source((SourceDirectorySet)scalaSource);
            sourceSet.getAllSource().source((SourceDirectorySet)scalaSource);
            project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName()).getDependencies().addLater(this.createScalaDependency(scalaPluginExtension));
            FileCollection incrementalAnalysis = ScalaBasePlugin.createIncrementalAnalysisConfigurationFor(project.getConfigurations(), incrementalAnalysisCategory, incrementalAnalysisUsage, sourceSet);
            this.createScalaCompileTask((Project)project, (SourceSet)sourceSet, scalaSource, incrementalAnalysis);
        });
    }

    private Provider<Dependency> createScalaDependency(ScalaPluginExtension scalaPluginExtension) {
        return scalaPluginExtension.getScalaVersion().map(scalaVersion -> {
            if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
                return this.dependencyFactory.create("org.scala-lang", "scala3-library_3", scalaVersion);
            }
            return this.dependencyFactory.create("org.scala-lang", "scala-library", scalaVersion);
        });
    }

    private Provider<Dependency> createScalaCompilerDependency(ScalaPluginExtension scalaPluginExtension) {
        return scalaPluginExtension.getScalaVersion().map(scalaVersion -> {
            if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
                return this.dependencyFactory.create("org.scala-lang", "scala3-compiler_3", scalaVersion);
            }
            return this.dependencyFactory.create("org.scala-lang", "scala-compiler", scalaVersion);
        });
    }

    private Provider<Dependency> createScalaBridgeDependency(ScalaPluginExtension scalaPluginExtension) {
        return scalaPluginExtension.getScalaVersion().zip(scalaPluginExtension.getZincVersion(), (scalaVersion, zincVersion) -> {
            if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
                return this.dependencyFactory.create("org.scala-lang", "scala3-sbt-bridge", scalaVersion);
            }
            String scalaMajorMinorVersion = Joiner.on((char)'.').join(Splitter.on((char)'.').splitToList((CharSequence)scalaVersion).subList(0, 2));
            String name = "compiler-bridge_" + scalaMajorMinorVersion;
            ExternalModuleDependency dependency = this.dependencyFactory.create("org.scala-sbt", name, zincVersion);
            dependency.artifact(artifact -> {
                artifact.setClassifier("sources");
                artifact.setType("jar");
                artifact.setExtension("jar");
                artifact.setName(name);
            });
            return dependency;
        });
    }

    private Provider<Dependency> createScalaCompilerInterfaceDependency(ScalaPluginExtension scalaPluginExtension) {
        return scalaPluginExtension.getScalaVersion().zip(scalaPluginExtension.getZincVersion(), (scalaVersion, zincVersion) -> {
            if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
                return this.dependencyFactory.create("org.scala-lang", "scala3-interfaces", scalaVersion);
            }
            return this.dependencyFactory.create("org.scala-sbt", "compiler-interface", zincVersion);
        });
    }

    private Provider<Dependency> createScaladocDependency(ScalaPluginExtension scalaPluginExtension) {
        return scalaPluginExtension.getScalaVersion().map(scalaVersion -> {
            if (ScalaRuntimeHelper.isScala3(scalaVersion)) {
                return this.dependencyFactory.create("org.scala-lang", "scaladoc_3", scalaVersion);
            }
            return null;
        });
    }

    private ScalaSourceDirectorySet createScalaSourceDirectorySet(SourceSet sourceSet) {
        String displayName = ((DefaultSourceSet)sourceSet).getDisplayName() + " Scala source";
        ScalaSourceDirectorySet scalaSourceDirectorySet = (ScalaSourceDirectorySet)this.objectFactory.newInstance(DefaultScalaSourceDirectorySet.class, new Object[]{this.objectFactory.sourceDirectorySet("scala", displayName)});
        scalaSourceDirectorySet.getFilter().include(new String[]{"**/*.java", "**/*.scala"});
        return scalaSourceDirectorySet;
    }

    private static FileCollection createIncrementalAnalysisConfigurationFor(RoleBasedConfigurationContainerInternal configurations, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage, SourceSet sourceSet) {
        Configuration classpath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        return classpath.getIncoming().artifactView(viewConfiguration -> {
            viewConfiguration.withVariantReselection();
            viewConfiguration.lenient(true);
            viewConfiguration.componentFilter(SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)element -> element instanceof ProjectComponentIdentifier));
            viewConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)incrementalAnalysisUsage);
            viewConfiguration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)incrementalAnalysisCategory);
        }).getFiles();
    }

    private void createScalaCompileTask(Project project, SourceSet sourceSet, ScalaSourceDirectorySet scalaSource, FileCollection incrementalAnalysis) {
        TaskProvider compileTask = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, scalaCompile -> {
            JvmPluginsHelper.compileAgainstJavaOutputs((AbstractCompile)scalaCompile, (SourceSet)sourceSet, (ObjectFactory)this.objectFactory);
            JvmPluginsHelper.configureAnnotationProcessorPath((SourceSet)sourceSet, (SourceDirectorySet)scalaSource, (CompileOptions)scalaCompile.getOptions(), (Project)project);
            scalaCompile.setDescription("Compiles the " + scalaSource + ".");
            scalaCompile.setSource((FileTree)scalaSource);
            scalaCompile.getJavaLauncher().convention(ScalaBasePlugin.getJavaLauncher(project));
            this.configureIncrementalAnalysis(project, sourceSet, incrementalAnalysis, (ScalaCompile)((Object)scalaCompile));
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)scalaSource, (Project)project, (TaskProvider)compileTask, (Provider)compileTask.map(AbstractScalaCompile::getOptions));
        project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{compileTask}));
    }

    private void configureIncrementalAnalysis(Project project, SourceSet sourceSet, FileCollection incrementalAnalysis, ScalaCompile scalaCompile) {
        scalaCompile.getAnalysisMappingFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".mapping"));
        IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
        incrementalOptions.getAnalysisFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis"));
        incrementalOptions.getClassfileBackupDir().set(project.getLayout().getBuildDirectory().file("tmp/scala/classfileBackup/" + scalaCompile.getName() + ".bak"));
        Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
        if (jarTask != null) {
            incrementalOptions.getPublishedCode().set(jarTask.getArchiveFile());
        }
        scalaCompile.getAnalysisFiles().from(new Object[]{incrementalAnalysis});
    }

    private static void configureCompileDefaults(Project project, ScalaRuntime scalaRuntime, DefaultJavaPluginExtension javaExtension, ScalaPluginExtension scalaPluginExtension, Provider<ResolvableConfiguration> scalaToolchainRuntimeClasspath) {
        project.getTasks().withType(ScalaCompile.class).configureEach(compile -> {
            ConventionMapping conventionMapping = compile.getConventionMapping();
            conventionMapping.map("scalaClasspath", () -> ScalaBasePlugin.getScalaToolchainClasspath(scalaPluginExtension, scalaToolchainRuntimeClasspath, scalaRuntime, compile.getClasspath()));
            conventionMapping.map("zincClasspath", () -> project.getConfigurations().getAt(ZINC_CONFIGURATION_NAME));
            conventionMapping.map(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME, () -> project.getConfigurations().getAt(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME));
            conventionMapping.map("sourceCompatibility", () -> ScalaBasePlugin.computeJavaSourceCompatibilityConvention(javaExtension, compile).toString());
            conventionMapping.map("targetCompatibility", () -> ScalaBasePlugin.computeJavaTargetCompatibilityConvention(javaExtension, compile).toString());
            compile.getScalaCompileOptions().getKeepAliveMode().convention((Object)KeepAliveMode.SESSION);
        });
    }

    private static JavaVersion computeJavaSourceCompatibilityConvention(DefaultJavaPluginExtension javaExtension, ScalaCompile compileTask) {
        JavaVersion rawSourceCompatibility = javaExtension.getRawSourceCompatibility();
        if (rawSourceCompatibility != null) {
            return rawSourceCompatibility;
        }
        return JavaVersion.toVersion((Object)((JavaLauncher)compileTask.getJavaLauncher().get()).getMetadata().getLanguageVersion().toString());
    }

    private static JavaVersion computeJavaTargetCompatibilityConvention(DefaultJavaPluginExtension javaExtension, ScalaCompile compileTask) {
        JavaVersion rawTargetCompatibility = javaExtension.getRawTargetCompatibility();
        if (rawTargetCompatibility != null) {
            return rawTargetCompatibility;
        }
        return JavaVersion.toVersion((Object)compileTask.getSourceCompatibility());
    }

    private static void configureScaladoc(Project project, ScalaRuntime scalaRuntime, ScalaPluginExtension scalaPluginExtension, Provider<ResolvableConfiguration> scalaToolchainRuntimeClasspath) {
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> {
            scalaDoc.getConventionMapping().map("scalaClasspath", () -> ScalaBasePlugin.getScalaToolchainClasspath(scalaPluginExtension, scalaToolchainRuntimeClasspath, scalaRuntime, scalaDoc.getClasspath()));
            scalaDoc.getConventionMapping().map("destinationDir", () -> ((Directory)ScalaBasePlugin.javaPluginExtension(project).getDocsDir().dir("scaladoc").get()).getAsFile());
            scalaDoc.getConventionMapping().map("title", () -> ReportUtilities.getApiDocTitleFor((Project)project));
            scalaDoc.getJavaLauncher().convention(ScalaBasePlugin.getJavaLauncher(project));
        });
    }

    private static FileCollection getScalaToolchainClasspath(ScalaPluginExtension scalaPluginExtension, Provider<ResolvableConfiguration> scalaToolchainRuntimeClasspath, ScalaRuntime scalaRuntime, FileCollection taskClasspath) {
        if (scalaPluginExtension.getScalaVersion().isPresent()) {
            return (FileCollection)scalaToolchainRuntimeClasspath.get();
        }
        return scalaRuntime.inferScalaClasspath((Iterable<File>)taskClasspath);
    }

    private static Provider<JavaLauncher> getJavaLauncher(Project project) {
        JavaPluginExtension extension = ScalaBasePlugin.javaPluginExtension(project);
        JavaToolchainService service = ScalaBasePlugin.extensionOf((ExtensionAware)project, JavaToolchainService.class);
        return service.launcherFor(extension.getToolchain());
    }

    private static JavaPluginExtension javaPluginExtension(Project project) {
        return ScalaBasePlugin.extensionOf((ExtensionAware)project, JavaPluginExtension.class);
    }

    private static <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return (T)extensionAware.getExtensions().getByType(type);
    }

    private static /* synthetic */ boolean lambda$configureSourceSetDefaults$17be3d40$1(FileCollection scalaSourceFiles, FileTreeElement element) {
        return scalaSourceFiles.contains(element.getFile());
    }

    private /* synthetic */ void lambda$createToolchainRuntimeClasspath$11(Provider scalaToolchain, ResolvableConfiguration conf) {
        conf.setDescription("Runtime classpath for the Scala toolchain");
        conf.extendsFrom(new Configuration[]{(Configuration)scalaToolchain.get()});
        this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)conf);
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        private final ImmutableSet<Usage> expectedUsages;
        private final Usage javaRuntime;

        @Inject
        UsageDisambiguationRules(Usage incrementalAnalysis, Usage javaApi, Usage javaRuntime) {
            this.javaRuntime = javaRuntime;
            this.expectedUsages = ImmutableSet.of((Object)incrementalAnalysis, (Object)javaApi, (Object)javaRuntime);
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            if (details.getConsumerValue() == null && details.getCandidateValues().equals(this.expectedUsages)) {
                details.closestMatch((Object)this.javaRuntime);
            }
        }
    }
}

