/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.EventDispatcher;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import java.awt.Component;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0002 !B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u001d\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/commit/message/CommitMessageInspectionDetails;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "myProfile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "myDefaultDescriptor", "Lcom/intellij/codeInspection/ex/Descriptor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/ex/InspectionProfileImpl;Lcom/intellij/codeInspection/ex/Descriptor;)V", "myToolState", "Lcom/intellij/codeInspection/ex/ScopeToolState;", "mySeverityChooser", "Lcom/intellij/profile/codeInspection/ui/LevelChooserAction;", "component", "Lcom/intellij/openapi/ui/DialogPanel;", "getComponent", "()Lcom/intellij/openapi/ui/DialogPanel;", "myEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/commit/message/CommitMessageInspectionDetails$ChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "key", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "getKey", "()Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "update", "addListener", "listener", "MySeverityChooser", "ChangeListener", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class CommitMessageInspectionDetails
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final InspectionProfileImpl myProfile;
    @NotNull
    private final Descriptor myDefaultDescriptor;
    @NotNull
    private final ScopeToolState myToolState;
    @NotNull
    private final LevelChooserAction mySeverityChooser;
    @NotNull
    private final DialogPanel component;
    @NotNull
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CommitMessageInspectionDetails(@NotNull Project myProject, @NotNull InspectionProfileImpl myProfile, @NotNull Descriptor myDefaultDescriptor) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myProfile, (String)"myProfile");
        Intrinsics.checkNotNullParameter((Object)myDefaultDescriptor, (String)"myDefaultDescriptor");
        this.myProject = myProject;
        this.myProfile = myProfile;
        this.myDefaultDescriptor = myDefaultDescriptor;
        EventDispatcher eventDispatcher = EventDispatcher.create(ChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.myEventDispatcher = eventDispatcher;
        ScopeToolState scopeToolState = this.myDefaultDescriptor.getState();
        Intrinsics.checkNotNullExpressionValue((Object)scopeToolState, (String)"getState(...)");
        this.myToolState = scopeToolState;
        this.mySeverityChooser = new MySeverityChooser(this.myProfile.getProfileManager().getSeverityRegistrar());
        MySeverityChooser mySeverityChooser = (MySeverityChooser)this.mySeverityChooser;
        Presentation presentation = this.mySeverityChooser.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        JComponent severityPanel = mySeverityChooser.createCustomComponent(presentation, "unknown");
        InspectionProfileEntry inspectionProfileEntry = this.myToolState.getTool().getTool();
        BaseCommitMessageInspection tool = inspectionProfileEntry instanceof BaseCommitMessageInspection ? (BaseCommitMessageInspection)inspectionProfileEntry : null;
        CommitMessageInspectionDetails disposable = this;
        this.component = BuilderKt.panel(arg_0 -> CommitMessageInspectionDetails._init_$lambda$3(tool, this, disposable, severityPanel, arg_0));
        this.component.reset();
    }

    @NotNull
    public final DialogPanel getComponent() {
        return this.component;
    }

    public void dispose() {
    }

    @NotNull
    public final HighlightDisplayKey getKey() {
        HighlightDisplayKey highlightDisplayKey = this.myDefaultDescriptor.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayKey, (String)"getKey(...)");
        return highlightDisplayKey;
    }

    public final void update() {
        Object[] objectArray = new ScopeToolState[]{this.myToolState};
        this.mySeverityChooser.setChosen(ScopesAndSeveritiesTable.getSeverity((List)CollectionsKt.mutableListOf((Object[])objectArray)));
        objectArray = new Component[]{this.component};
        GuiUtils.enableChildren((boolean)this.myToolState.isEnabled(), (Component[])objectArray);
    }

    public final void addListener(@NotNull ChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    private static final Unit lambda$3$lambda$0(JComponent $severityPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($severityPanel);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2(JComponent $defaultPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($defaultPanel);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(BaseCommitMessageInspection $tool, CommitMessageInspectionDetails this$0, CommitMessageInspectionDetails $disposable, JComponent $severityPanel, Panel $this$panel) {
        JComponent defaultPanel;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CommitMessageInspectionDetails.lambda$3$lambda$0($severityPanel, arg_0));
        boolean createDefault = false;
        if ($tool != null) {
            Panel panel = $this$panel;
            BaseCommitMessageInspection $this$lambda_u243_u24lambda_u241 = $tool;
            boolean bl = false;
            createDefault = $this$lambda_u243_u24lambda_u241.createOptions(panel, this$0.myProject, $disposable);
        } else {
            createDefault = true;
        }
        if (createDefault && (defaultPanel = this$0.myToolState.getAdditionalConfigPanel((Disposable)$disposable, this$0.myProject)) != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> CommitMessageInspectionDetails.lambda$3$lambda$2(defaultPanel, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/commit/message/CommitMessageInspectionDetails$ChangeListener;", "Ljava/util/EventListener;", "onSeverityChanged", "", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "intellij.platform.vcs.impl"})
    public static interface ChangeListener
    extends EventListener {
        public void onSeverityChanged(@NotNull HighlightSeverity var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/commit/message/CommitMessageInspectionDetails$MySeverityChooser;", "Lcom/intellij/profile/codeInspection/ui/LevelChooserAction;", "registrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "<init>", "(Lcom/intellij/vcs/commit/message/CommitMessageInspectionDetails;Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;)V", "onChosen", "", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "intellij.platform.vcs.impl"})
    private final class MySeverityChooser
    extends LevelChooserAction {
        public MySeverityChooser(SeverityRegistrar registrar) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            super(registrar);
        }

        protected void onChosen(@NotNull HighlightSeverity severity) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            HighlightDisplayLevel level = HighlightDisplayLevel.Companion.find(severity);
            InspectionProfileImpl inspectionProfileImpl = CommitMessageInspectionDetails.this.myProfile;
            HighlightDisplayKey highlightDisplayKey = CommitMessageInspectionDetails.this.myDefaultDescriptor.getKey();
            HighlightDisplayLevel highlightDisplayLevel = level;
            Intrinsics.checkNotNull((Object)highlightDisplayLevel);
            inspectionProfileImpl.setErrorLevel(highlightDisplayKey, highlightDisplayLevel, null, CommitMessageInspectionDetails.this.myProject);
            ((ChangeListener)CommitMessageInspectionDetails.this.myEventDispatcher.getMulticaster()).onSeverityChanged(severity);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            ComboBoxAction.ComboBoxButton comboBoxButton = this.createComboBoxButton(presentation);
            Intrinsics.checkNotNullExpressionValue((Object)comboBoxButton, (String)"createComboBoxButton(...)");
            return (JComponent)comboBoxButton;
        }
    }
}

