/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayPositionsFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayPositionsFunction
extends AbstractArrayPositionsFunction {
    public OracleArrayPositionsFunction(boolean list, TypeConfiguration typeConfiguration) {
        super(list, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        String arrayTypeName = DdlTypeHelper.getTypeName(arrayExpression.getExpressionType(), walker.getSessionFactory().getTypeConfiguration());
        sqlAppender.appendSql(arrayTypeName);
        sqlAppender.append("_positions(");
        arrayExpression.accept(walker);
        sqlAppender.append(',');
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append(")");
    }
}

