/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.action.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.ui.action.command.Command;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Lookup;

public class PlatformCommand
extends Command {
    private final String commandId;

    public PlatformCommand(ClientSideProject project, String commandId) {
        super(project);
        assert (commandId != null);
        this.commandId = commandId;
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    @Override
    boolean isActionEnabledInternal(Lookup context) {
        for (PlatformProvider provider : this.project.getPlatformProviders()) {
            ActionProvider actionProvider = provider.getActionProvider((Project)this.project);
            if (actionProvider == null || !PlatformCommand.isSupportedAction(this.commandId, actionProvider) || !actionProvider.isActionEnabled(this.commandId, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    void invokeActionInternal(final Lookup context) {
        for (PlatformProvider provider : this.project.getPlatformProviders()) {
            final ActionProvider actionProvider = provider.getActionProvider((Project)this.project);
            if (actionProvider == null || !PlatformCommand.isSupportedAction(this.commandId, actionProvider) || !actionProvider.isActionEnabled(this.commandId, context)) continue;
            PlatformCommand.runInEventThread(new Runnable(){
                final /* synthetic */ PlatformCommand this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    actionProvider.invokeAction(this.this$0.commandId, context);
                }
            });
        }
    }

    public List<String> getSupportedActions() {
        ArrayList<String> supportedActions = new ArrayList<String>();
        for (PlatformProvider provider : this.project.getPlatformProviders()) {
            ActionProvider actionProvider = provider.getActionProvider((Project)this.project);
            if (actionProvider == null) continue;
            supportedActions.addAll(Arrays.asList(actionProvider.getSupportedActions()));
        }
        return supportedActions;
    }
}

