/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.cpplite.project.Utils;

public class BuildConfiguration {
    private static final String KEY_NAME = "name";
    private final String name;
    private final Map<String, List<List<String>>> commands;

    public BuildConfiguration(String name, Map<String, List<List<String>>> commands) {
        this.name = name;
        this.commands = commands;
    }

    public String getName() {
        return this.name;
    }

    public List<List<String>> executablesFor(String command) {
        return this.commands.get(command);
    }

    public void save(Preferences prefs) {
        prefs.put(KEY_NAME, this.name);
        for (String command : new String[]{"build", "clean", "run"}) {
            List<List<String>> executablesFor = this.commands.get(command);
            if (executablesFor == null) {
                prefs.remove(command);
                continue;
            }
            prefs.put(command, Utils.encode(executablesFor));
        }
    }

    public static BuildConfiguration read(Preferences prefs) {
        HashMap<String, List<List<String>>> commands = new HashMap<String, List<List<String>>>();
        for (String command : new String[]{"build", "clean", "run"}) {
            String cmd = prefs.get(command, null);
            if (cmd == null || cmd.isEmpty()) continue;
            commands.put(command, Utils.decode(cmd));
        }
        return new BuildConfiguration(prefs.get(KEY_NAME, ""), commands);
    }
}

