/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class CodeUncommentAction
extends ExtKit.UncommentAction {
    public CodeUncommentAction() {
        super("");
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            final BaseDocument doc = (BaseDocument)target.getDocument();
            Caret caret = target.getCaret();
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            if (th == null) {
                return;
            }
            final TokenSequence ts = th.tokenSequence();
            try {
                if (caret.isSelectionVisible()) {
                    final int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                    final int endPos = target.getSelectionEnd();
                    doc.runAtomicAsUser(new Runnable(){
                        final /* synthetic */ CodeUncommentAction this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            try {
                                int end = endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos ? endPos - 1 : endPos;
                                int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)end);
                                ArrayList<String> mimeTypes = new ArrayList<String>(lineCnt);
                                int pos = startPos;
                                for (int x = lineCnt; x > 0; --x) {
                                    mimeTypes.add(this.this$0.getRealMimeType(ts, pos));
                                    pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                                }
                                pos = startPos;
                                Iterator iter = mimeTypes.iterator();
                                while (iter.hasNext()) {
                                    this.this$0.modifyLine(doc, (String)iter.next(), pos);
                                    pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                                }
                            }
                            catch (BadLocationException e) {
                                target.getToolkit().beep();
                            }
                        }
                    });
                } else {
                    final int pos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                    final String mt = this.getRealMimeType(ts, pos);
                    doc.runAtomicAsUser(new Runnable(){
                        final /* synthetic */ CodeUncommentAction this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            try {
                                this.this$0.modifyLine(doc, mt, pos);
                            }
                            catch (BadLocationException e) {
                                target.getToolkit().beep();
                            }
                        }
                    });
                }
            }
            catch (BadLocationException e) {
                target.getToolkit().beep();
            }
        }
    }

    private String getRealMimeType(TokenSequence ts, int offset) {
        while (true) {
            ts.move(offset);
            if (!ts.moveNext()) break;
            offset = ts.offset();
            TokenSequence ts2 = ts.embedded();
            if (ts2 == null) break;
            ts = ts2;
        }
        return ts.language().mimeType();
    }

    private void modifyLine(BaseDocument doc, String mimeType, int offset) throws BadLocationException {
        Feature feature = null;
        try {
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            feature = language.getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException language) {
            // empty catch block
        }
        if (feature != null) {
            int firstNonWhitePos;
            CharSequence maybeLineComment;
            int commentLen;
            int lastNonWhitePos;
            String prefix = (String)feature.getValue("prefix");
            if (prefix == null) {
                return;
            }
            String suffix = (String)feature.getValue("suffix");
            if (suffix != null && (lastNonWhitePos = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset)) != -1) {
                commentLen = suffix.length();
                if (lastNonWhitePos - Utilities.getRowStart((BaseDocument)doc, (int)offset) >= commentLen && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)(lastNonWhitePos - commentLen + 1), (int)commentLen)), (CharSequence)suffix)) {
                    doc.remove(lastNonWhitePos - commentLen + 1, commentLen);
                }
            }
            if ((firstNonWhitePos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1) {
                commentLen = prefix.length();
                if (Utilities.getRowEnd((BaseDocument)doc, (int)firstNonWhitePos) - firstNonWhitePos >= prefix.length() && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)firstNonWhitePos, (int)commentLen)), (CharSequence)prefix)) {
                    doc.remove(firstNonWhitePos, commentLen);
                }
            }
        }
    }
}

