/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.modules.j2ee.jpa.verification.fixes.PickOrCreateFieldPanel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CreateId
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;
    private AccessType accessType;

    public CreateId(FileObject fileObject, ElementHandle<TypeElement> classHandle, AccessType accessType) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
        this.accessType = accessType;
    }

    public ChangeInfo implement() {
        PickOrCreateFieldPanel pnlPickOrCreateField = new PickOrCreateFieldPanel();
        pnlPickOrCreateField.setAvailableFields(this.getAvailableFields());
        pnlPickOrCreateField.setFileObject(this.fileObject);
        DialogDescriptor ddesc = new DialogDescriptor((Object)pnlPickOrCreateField, NbBundle.getMessage(CreateId.class, (String)"LBL_AddIDAnnotationDlgTitle"));
        ddesc.createNotificationLineSupport();
        Dialog dlg = DialogDisplayer.getDefault().createDialog(ddesc);
        pnlPickOrCreateField.setDlgDescriptor(ddesc);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        if (ddesc.getValue() == DialogDescriptor.OK_OPTION) {
            if (pnlPickOrCreateField.wasCreateNewFieldSelected()) {
                this.createIDField(pnlPickOrCreateField.getNewIdName(), pnlPickOrCreateField.getSelectedIdType());
            } else {
                String fieldName = (String)pnlPickOrCreateField.getSelectedField();
                this.createIDField(fieldName, null);
            }
        }
        return null;
    }

    private String[] getAvailableFields() {
        String[] result = null;
        MetadataModel<EntityMappingsMetadata> emModel = ModelUtils.getModel(this.fileObject);
        if (emModel != null) {
            try {
                result = (String[])emModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, String[]>(){
                    List<String> fieldNames = new ArrayList<String>();

                    public String[] run(EntityMappingsMetadata metadata) {
                        Entity entity = ModelUtils.getEntity(metadata, CreateId.this.classHandle.getQualifiedName());
                        if (entity != null) {
                            for (Basic basic : entity.getAttributes().getBasic()) {
                                String name = basic.getName();
                                if (!Utilities.isJavaIdentifier((String)name)) continue;
                                this.fieldNames.add(name);
                            }
                        }
                        return this.fieldNames.toArray(new String[0]);
                    }
                });
            }
            catch (IOException ex) {
                JPAProblemFinder.LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            JPAProblemFinder.LOG.severe("Could not read merged model");
        }
        return result;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"MSG_MissingIDAnnotationHint");
    }

    private void createIDField(final String fieldName, final String typeName) {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){
            final /* synthetic */ CreateId this$0;
            {
                this.this$0 = this$0;
            }

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement clazz = (TypeElement)this.this$0.classHandle.resolve((CompilationInfo)workingCopy);
                if (clazz != null) {
                    ExecutableElement getterElement;
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    ClassTree clazzTree = workingCopy.getTrees().getTree(clazz);
                    TreeMaker make = workingCopy.getTreeMaker();
                    boolean usedExistingField = true;
                    boolean usedExistingGetter = true;
                    VariableTree fieldTree = null;
                    MethodTree accesorTree = null;
                    MethodTree mutatorTree = null;
                    Tree type = typeName == null || "".equals(typeName) ? null : genUtils.createType(typeName, clazz);
                    VariableElement fieldElem = ModelUtils.getField(clazz, fieldName);
                    if (fieldElem != null) {
                        fieldTree = (VariableTree)workingCopy.getTrees().getTree(fieldElem);
                        if (type == null) {
                            type = fieldTree.getType();
                        }
                    }
                    if ((getterElement = ModelUtils.getAccesor(clazz, fieldName)) != null) {
                        accesorTree = workingCopy.getTrees().getTree(getterElement);
                        if (type == null) {
                            type = accesorTree.getReturnType();
                        }
                    }
                    if (fieldTree == null) {
                        fieldTree = genUtils.createField(clazz, make.Modifiers(Collections.singleton(Modifier.PRIVATE)), fieldName, typeName, null);
                        usedExistingField = false;
                    }
                    if (accesorTree == null) {
                        accesorTree = genUtils.createPropertyGetterMethod(make.Modifiers(Collections.singleton(Modifier.PUBLIC)), fieldName, type);
                        mutatorTree = genUtils.createPropertySetterMethod(make.Modifiers(Collections.singleton(Modifier.PUBLIC)), fieldName, type);
                        usedExistingGetter = false;
                    }
                    ModifiersTree toAnnotate = this.this$0.accessType == AccessType.FIELD ? fieldTree.getModifiers() : accesorTree.getModifiers();
                    AnnotationTree idAnnotation = genUtils.createAnnotation("javax.persistence.Id");
                    workingCopy.rewrite((Tree)toAnnotate, (Tree)make.addModifiersAnnotation(toAnnotate, idAnnotation));
                    ClassTree modifiedClazz = clazzTree;
                    if (!usedExistingField) {
                        modifiedClazz = genUtils.addClassFields(modifiedClazz, Collections.singletonList(fieldTree));
                    }
                    if (!usedExistingGetter) {
                        modifiedClazz = make.addClassMember(modifiedClazz, (Tree)accesorTree);
                        modifiedClazz = make.addClassMember(modifiedClazz, (Tree)mutatorTree);
                    }
                    if (modifiedClazz != clazzTree) {
                        workingCopy.rewrite((Tree)clazzTree, (Tree)modifiedClazz);
                    }
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

