/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.components.ImageBlenderPanel;

public class ComponentMorpher2
extends JComponent {
    private Image endComponentImage;
    private Image startComponentImage;
    private ImageBlenderPanel blenderPanel;
    private JComponent component1;
    private JComponent component2;
    private JComponent currentComponent;
    private JComponent endComponent;
    private JComponent startComponent;
    private boolean isMorphing = false;
    private float heightDelta;
    private int morphingDelay;
    private int morphingStep;
    private int morphingSteps;

    public ComponentMorpher2(JComponent component1, JComponent component2) {
        this(component1, component2, 10, 15);
    }

    public ComponentMorpher2(JComponent component1, JComponent component2, int morphingSteps, int morphingDelay) {
        this.component1 = component1;
        this.component2 = component2;
        this.setMorphingSteps(morphingSteps);
        this.setMorphingDelay(morphingDelay);
        this.setLayout(new BorderLayout());
        this.setCurrentComponent(component1);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.setClientPreferredSize(this.currentComponent.getPreferredSize());
    }

    public boolean isExpanded() {
        return this.currentComponent == this.component2;
    }

    public boolean isMorphing() {
        return this.isMorphing;
    }

    public void setMorphingDelay(int morphingDelay) {
        this.morphingDelay = morphingDelay;
    }

    public int getMorphingDelay() {
        return this.morphingDelay;
    }

    public void setMorphingSteps(int morphingSteps) {
        this.morphingSteps = morphingSteps;
    }

    public int getMorphingSteps() {
        return this.morphingSteps;
    }

    public void morph() {
        if (!this.isMorphing()) {
            new MorpherThread().start();
        }
    }

    public void morphingStep() {
        if (this.morphingStep > this.morphingSteps) {
            return;
        }
        if (this.morphingStep == 0) {
            this.setCurrentComponent(this.blenderPanel);
        } else if (this.morphingStep == this.morphingSteps) {
            this.setCurrentComponent(this.endComponent);
            this.isMorphing = false;
        } else {
            Dimension newDim = new Dimension(this.getClientSize().width, this.startComponentImage.getHeight(null) + (int)((float)this.morphingStep * this.heightDelta));
            this.blenderPanel.setBlendAlpha((float)this.morphingStep / (float)this.morphingSteps);
            this.blenderPanel.setSize(newDim);
            this.setClientPreferredSize(newDim);
        }
        this.refresh();
        ++this.morphingStep;
    }

    public void refresh() {
        this.revalidate();
        this.repaint();
    }

    public void setupMorphing() {
        this.startComponent = this.currentComponent == this.component1 ? this.component1 : this.component2;
        this.endComponent = this.currentComponent == this.component1 ? this.component2 : this.component1;
        this.startComponentImage = this.getComponentImage(this.startComponent);
        this.endComponentImage = this.getComponentImage(this.endComponent);
        this.heightDelta = (float)(this.endComponentImage.getHeight(null) - this.startComponentImage.getHeight(null)) / (float)this.morphingSteps;
        this.blenderPanel = new ImageBlenderPanel(this.startComponentImage, this.endComponentImage, this.component1.getBackground(), 0.0f);
        this.blenderPanel.setPreferredSize(new Dimension(this.startComponentImage.getWidth(null), this.startComponentImage.getHeight(null)));
        this.morphingStep = 0;
        this.isMorphing = true;
    }

    private void setClientPreferredSize(Dimension size) {
        Insets insets = this.getInsets();
        this.setPreferredSize(new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom));
    }

    private Dimension getClientSize() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        return new Dimension(size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    private Image getComponentImage(JComponent component) {
        component.setSize(this.getClientSize().width == 0 ? component.getPreferredSize() : this.getClientSize());
        component.doLayout();
        component.setSize(new Dimension(this.getClientSize().width, component.getPreferredSize().height));
        component.doLayout();
        component.setSize(new Dimension(this.getClientSize().width, component.getPreferredSize().height));
        component.doLayout();
        BufferedImage componentImage = new BufferedImage(component.getSize().width, component.getSize().height, 1);
        component.printAll(componentImage.getGraphics());
        return componentImage;
    }

    private void setCurrentComponent(JComponent component) {
        if (this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = component;
        this.add((Component)this.currentComponent, "Center");
        this.setClientPreferredSize(this.currentComponent.getPreferredSize());
    }

    private class MorpherThread
    extends Thread {
        private MorpherThread() {
        }

        @Override
        public void run() {
            ComponentMorpher2.this.setupMorphing();
            while (ComponentMorpher2.this.isMorphing()) {
                ComponentMorpher2.this.morphingStep();
                try {
                    Thread.sleep(ComponentMorpher2.this.morphingDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

