/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.util.Iterator;
import java.util.NoSuchElementException;

class ObjectSet {
    private Hash hash;
    private Object[] table;
    private float loadFactor = 0.75f;
    private int limit;
    private int size;

    public ObjectSet() {
        this(new Hash(){

            @Override
            public boolean equals(Object o1, Object o2) {
                return o1.equals(o2);
            }

            @Override
            public int hashCodeFor(Object o) {
                return o.hashCode();
            }
        });
    }

    public ObjectSet(Hash hash) {
        this.hash = hash;
        this.table = new Object[11];
        this.limit = (int)((float)this.table.length * this.loadFactor);
    }

    public Object get(Object key) {
        int bucket = (this.hash.hashCodeFor(key) & Integer.MAX_VALUE) % this.table.length;
        while (this.table[bucket] != null) {
            if (this.hash.equals(key, this.table[bucket])) {
                return this.table[bucket];
            }
            bucket = (bucket + 1) % this.table.length;
        }
        return null;
    }

    public void put(Object key) {
        if (this.size + 1 > this.limit) {
            this.rehash(this.table.length * 2);
        }
        ++this.size;
        int bucket = (this.hash.hashCodeFor(key) & Integer.MAX_VALUE) % this.table.length;
        while (this.table[bucket] != null && !this.hash.equals(key, this.table[bucket])) {
            bucket = (bucket + 1) % this.table.length;
        }
        this.table[bucket] = key;
    }

    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    public Iterator iterator() {
        return new Iterator(){
            int ptr = 0;
            Object next;

            @Override
            public boolean hasNext() {
                while (this.next == null && this.ptr < ObjectSet.this.table.length) {
                    this.next = ObjectSet.this.table[this.ptr++];
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void rehash(int newSize) {
        Object[] newTable = new Object[newSize];
        for (int i = 0; i < this.table.length; ++i) {
            Object act = this.table[i];
            if (act == null) continue;
            int bucket = (this.hash.hashCodeFor(act) & Integer.MAX_VALUE) % newTable.length;
            while (newTable[bucket] != null) {
                bucket = (bucket + 1) % newTable.length;
            }
            newTable[bucket] = act;
        }
        this.table = newTable;
        this.limit = (int)((float)this.table.length * this.loadFactor);
    }

    public static interface Hash {
        public int hashCodeFor(Object var1);

        public boolean equals(Object var1, Object var2);
    }
}

