/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.BeanModelBuilder;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBeanCache;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBeanProvider;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinition;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;
import org.netbeans.modules.javafx2.editor.completion.beans.FxEvent;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;

public final class FxBean
extends FxDefinition {
    private boolean hasValueOf;
    private ElementHandle<TypeElement> javaType;
    private FxBean createdBean;
    private Map<String, FxProperty> simpleProperties = Collections.emptyMap();
    private Map<String, FxProperty> properties = Collections.emptyMap();
    private Map<String, FxProperty> attachedProperties = Collections.emptyMap();
    private Map<String, FxEvent> events = Collections.emptyMap();
    private Map<String, TypeMirrorHandle> factories = Collections.emptyMap();
    private Set<String> constants = Collections.emptySet();
    private FxBean superclassInfo;
    private FxBean declaredInfo;
    private String defaultPropertyName;
    private boolean fxInstance;
    private FxBean builder;
    private boolean map;
    private boolean collection;

    public static FxBeanProvider getBeanProvider(final CompilationInfo info) {
        return new FxBeanProvider(){

            @Override
            public FxBean getBeanInfo(String fqn) {
                if (fqn == null) {
                    return null;
                }
                FxBeanCache cache = FxBeanCache.instance();
                FxBean bean = cache.getBeanInfo(info.getClasspathInfo(), fqn);
                if (bean != null) {
                    return bean;
                }
                BeanModelBuilder bmb = new BeanModelBuilder(this, info, fqn);
                bmb.setBeanCache(cache);
                return bmb.getBeanInfo();
            }

            @Override
            public CompilationInfo getCompilationInfo() {
                return info;
            }
        };
    }

    @CheckForNull
    public FxProperty getDefaultProperty() {
        return this.defaultPropertyName == null ? null : this.properties.get(this.defaultPropertyName);
    }

    @NonNull
    public Set<String> getFactoryNames() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public TypeMirrorHandle getFactoryType(String fName) {
        return this.factories.get(fName);
    }

    void setFactories(Map<String, TypeMirrorHandle> factories) {
        this.factories = factories;
    }

    void setBuilder(FxBean builder) {
        this.builder = builder;
    }

    public FxBean getBuilder() {
        return this.builder;
    }

    public boolean usesBuilder() {
        return !this.fxInstance && this.getBuilder() != null;
    }

    void makeBuilder(FxBean created) {
        this.createdBean = created;
    }

    void makeMap() {
        this.map = true;
    }

    void makeCollection() {
        this.collection = true;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isMap() {
        return this.map;
    }

    public boolean isBuilder() {
        return this.createdBean != null;
    }

    public FxBean getCreatedBean() {
        return this.createdBean;
    }

    @NonNull
    public String getClassName() {
        return this.getName();
    }

    @NonNull
    public ElementHandle<TypeElement> getJavaType() {
        return this.javaType;
    }

    @NonNull
    public Map<String, FxProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @NonNull
    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @NonNull
    public Map<String, FxProperty> getSimpleProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @NonNull
    public Collection<String> getSimplePropertyNames() {
        return Collections.unmodifiableSet(this.simpleProperties.keySet());
    }

    @NonNull
    public Collection<String> getAttachedPropertyNames() {
        return Collections.unmodifiableSet(this.attachedProperties.keySet());
    }

    @CheckForNull
    public FxProperty getProperty(String n) {
        return this.properties.get(n);
    }

    public FxProperty getSimpleProperty(String n) {
        return this.simpleProperties.get(n);
    }

    @CheckForNull
    public FxProperty getAttachedProperty(String n) {
        return this.attachedProperties.get(n);
    }

    @NonNull
    public Map<String, FxProperty> getAttachedProperties() {
        return Collections.unmodifiableMap(this.attachedProperties);
    }

    public Set<String> getEventNames() {
        return Collections.unmodifiableSet(this.events.keySet());
    }

    public Map<String, FxEvent> getEvents() {
        return Collections.unmodifiableMap(this.events);
    }

    public FxEvent getEvent(String eventName) {
        FxEvent ev = this.events.get(eventName);
        return ev;
    }

    FxBean(String className) {
        super(className);
    }

    void setFxInstance(boolean bean) {
        this.fxInstance = bean;
    }

    public boolean isFxInstance() {
        return this.fxInstance;
    }

    void setValueOf(boolean has) {
        this.hasValueOf = has;
    }

    public boolean hasValueOf() {
        return this.hasValueOf;
    }

    void setDefaultPropertyName(String propName) {
        this.defaultPropertyName = propName;
    }

    void setJavaType(ElementHandle<TypeElement> javaType) {
        this.javaType = javaType;
    }

    void setProperties(Map<String, FxProperty> properties) {
        this.properties = properties;
    }

    void setSimpleProperties(Map<String, FxProperty> properties) {
        this.simpleProperties = properties;
    }

    void setAttachedProperties(Map<String, FxProperty> attachedProperties) {
        this.attachedProperties = attachedProperties;
    }

    void setEvents(Map<String, FxEvent> events) {
        this.events = events;
    }

    void setParentBeanInfo(FxBean parent) {
        this.superclassInfo = parent;
    }

    void setConstants(Set<String> constants) {
        this.constants = constants;
    }

    @CheckForNull
    public FxBean getSuperclassInfo() {
        return this.superclassInfo;
    }

    public Set<String> getConstants() {
        return Collections.unmodifiableSet(this.constants);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanInfo[");
        sb.append("\n  className: ").append(this.getClassName()).append("; default: ").append(this.getDefaultProperty()).append("; value: ").append(this.hasValueOf).append("\n factories: ").append(this.getFactoryNames());
        sb.append("\n properties: ").append("\n");
        this.appendMap(sb, this.getProperties());
        sb.append("\n events: ").append("\n");
        this.appendMap(sb, this.getEvents());
        return sb.toString();
    }

    private void appendMap(StringBuilder sb, Map m) {
        ArrayList al = new ArrayList(m.keySet());
        Collections.sort(al);
        for (Object o : al) {
            Object v = m.get(o);
            sb.append("    ").append(v).append("\n");
        }
    }

    @NonNull
    public FxBean getDeclareadInfo() {
        return this.declaredInfo;
    }

    void setDeclaredInfo(FxBean declaredInfo) {
        this.declaredInfo = declaredInfo;
    }

    void merge(FxBean superBi) {
        if (superBi == null) {
            return;
        }
        if (superBi.isMap()) {
            this.makeMap();
        }
        if (superBi.isCollection()) {
            this.makeCollection();
        }
        if (this.attachedProperties.isEmpty() && !superBi.getAttachedProperties().isEmpty()) {
            this.attachedProperties = new HashMap<String, FxProperty>(superBi.getAttachedProperties());
        } else {
            this.attachedProperties.putAll(superBi.getAttachedProperties());
        }
        if (this.properties.isEmpty() && !superBi.getProperties().isEmpty()) {
            this.properties = new HashMap<String, FxProperty>(superBi.getProperties());
        } else {
            this.properties.putAll(superBi.getProperties());
        }
        if (this.simpleProperties.isEmpty() && !superBi.getSimpleProperties().isEmpty()) {
            this.simpleProperties = new HashMap<String, FxProperty>(superBi.getSimpleProperties());
        } else {
            this.simpleProperties.putAll(superBi.getSimpleProperties());
        }
        if (this.events.isEmpty() && !superBi.getEvents().isEmpty()) {
            this.events = new HashMap<String, FxEvent>(superBi.getEvents());
        } else {
            this.events.putAll(superBi.getEvents());
        }
        if (this.defaultPropertyName == null && superBi.getDefaultProperty() != null) {
            this.defaultPropertyName = superBi.getDefaultProperty().getName();
        }
    }

    @Override
    public FxDefinitionKind getKind() {
        return FxDefinitionKind.BEAN;
    }
}

