/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.commit;

import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.Validations;
import org.netbeans.modules.docker.ui.commit.Bundle;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitPanel
extends JPanel {
    private final JButton actionButton;
    private NotificationLineSupport messageLine;
    private JLabel authorLabel;
    private JTextField authorTextField;
    private JScrollPane jScrollPane1;
    private JLabel messageLabel;
    private JTextArea messageTextArea;
    private JCheckBox pauseCheckBox;
    private JComboBox<String> repositoryComboBox;
    private JLabel repositoryLabel;
    private JLabel tagLabel;
    private JTextField tagTextField;

    public CommitPanel(DockerInstance instance, JButton actionButton) {
        this.initComponents();
        this.actionButton = actionButton;
        DefaultDocumentListener listener = new DefaultDocumentListener();
        ((JTextComponent)this.repositoryComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
        this.tagTextField.getDocument().addDocumentListener(listener);
        this.authorTextField.setText(System.getProperty("user.name"));
        UiUtils.loadRepositories(instance, this.repositoryComboBox);
    }

    public void setMessageLine(NotificationLineSupport messageLine) {
        this.messageLine = messageLine;
        this.validateInput();
    }

    private void validateInput() {
        String message;
        String message2;
        if (this.messageLine == null) {
            return;
        }
        this.messageLine.clearMessages();
        this.actionButton.setEnabled(true);
        if (this.getRepository() == null && this.getTag() != null) {
            this.messageLine.setErrorMessage(Bundle.MSG_EmptyRepository());
            this.actionButton.setEnabled(false);
            return;
        }
        String repository = this.getRepository();
        if (repository != null && (message2 = Validations.validateRepository(repository)) != null) {
            this.messageLine.setErrorMessage(message2);
            this.actionButton.setEnabled(false);
            return;
        }
        String tag = this.getTag();
        if (tag != null && (message = Validations.validateTag(tag)) != null) {
            this.messageLine.setErrorMessage(message);
            this.actionButton.setEnabled(false);
            return;
        }
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.pauseCheckBox = new JCheckBox();
        this.repositoryLabel = new JLabel();
        this.repositoryComboBox = new JComboBox();
        this.tagLabel = new JLabel();
        this.tagTextField = new JTextField();
        this.authorLabel = new JLabel();
        this.authorTextField = new JTextField();
        this.messageLabel.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.messageLabel.text"));
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.pauseCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.pauseCheckBox, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.pauseCheckBox.text"));
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.repositoryLabel.text"));
        this.repositoryComboBox.setEditable(true);
        this.tagLabel.setLabelFor(this.tagTextField);
        Mnemonics.setLocalizedText((JLabel)this.tagLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.tagLabel.text"));
        this.authorLabel.setLabelFor(this.authorTextField);
        Mnemonics.setLocalizedText((JLabel)this.authorLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.authorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 476, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryLabel).addComponent(this.tagLabel).addComponent(this.authorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.tagTextField).addComponent(this.authorTextField))).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.pauseCheckBox, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryLabel).addComponent(this.repositoryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagLabel).addComponent(this.tagTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorLabel).addComponent(this.authorTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pauseCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public String getRepository() {
        return UiUtils.getValue(this.repositoryComboBox);
    }

    public String getTag() {
        return UiUtils.getValue(this.tagTextField);
    }

    public String getAuthor() {
        return UiUtils.getValue(this.authorTextField);
    }

    public String getMessage() {
        return UiUtils.getValue(this.messageTextArea);
    }

    public boolean isPause() {
        return this.pauseCheckBox.isSelected();
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CommitPanel.this.validateInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CommitPanel.this.validateInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CommitPanel.this.validateInput();
        }
    }
}

