/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListTaggingWorkRequestLogsRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String page;
    private Integer limit;

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId).page(this.page).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTaggingWorkRequestLogsRequest)) {
            return false;
        }
        ListTaggingWorkRequestLogsRequest other = (ListTaggingWorkRequestLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTaggingWorkRequestLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workRequestId = null;
        private String page = null;
        private Integer limit = null;

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTaggingWorkRequestLogsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTaggingWorkRequestLogsRequest build() {
            ListTaggingWorkRequestLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTaggingWorkRequestLogsRequest buildWithoutInvocationCallback() {
            ListTaggingWorkRequestLogsRequest request = new ListTaggingWorkRequestLogsRequest();
            request.workRequestId = this.workRequestId;
            request.page = this.page;
            request.limit = this.limit;
            return request;
        }
    }
}

