/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.netbeans.lib.nbjshell.LaunchJDIAgent;
import org.netbeans.lib.nbjshell.NbExecutionControl;
import org.netbeans.lib.nbjshell.RemoteJShellService;
import org.netbeans.modules.jshell.launch.JShellConnection;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchListener;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;

public class DebugExecutionEnvironment
extends LaunchJDIAgent
implements RemoteJShellService,
NbExecutionControl,
ShellLaunchListener {
    private static final Logger LOG = Logger.getLogger(DebugExecutionEnvironment.class.getName());
    private static final String AGENT_VARVALUE_METHOD = "varValue";
    private static final String AGENT_INVOKE_METHOD = "invoke";
    private static final String REMOTE_AGENT_CLASS = "jdk.jshell.execution.RemoteExecutionControl";
    private boolean added;
    private volatile JShellConnection shellConnection;
    private boolean closed;
    final ShellAgent agent;

    public DebugExecutionEnvironment(ShellAgent agent, ObjectOutput out, ObjectInput in, VirtualMachine vm, JShellConnection c) {
        super(out, in, vm);
        this.agent = agent;
        ShellLaunchManager.getInstance().addLaunchListener(this);
        this.shellConnection = c;
    }

    @Override
    public String getTargetSpec() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JShellConnection getOpenedConnection() {
        DebugExecutionEnvironment debugExecutionEnvironment = this;
        synchronized (debugExecutionEnvironment) {
            return this.shellConnection;
        }
    }

    public ShellAgent getAgent() {
        return this.agent;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public ObjectOutput getOut() {
        return this.out;
    }

    protected ObjectInput getIn() {
        return this.in;
    }

    protected void shutdown() {
        this.agent.closeConnection(this.shellConnection);
        if (this.in == null) {
            return;
        }
        ShellLaunchManager.getInstance().removeLaunchListener(this);
        this.closeStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isUserCodeRunning()) {
                this.sendStopUserCode();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.closeStreams();
    }

    public boolean sendStopUserCode() throws IllegalStateException {
        if (this.closed) {
            return false;
        }
        this.vm.suspend();
        try {
            ObjectReference myRef = this.getAgentObjectReference();
            block6: for (ThreadReference thread : this.vm.allThreads()) {
                for (StackFrame frame : thread.frames()) {
                    String n;
                    if (!REMOTE_AGENT_CLASS.equals(frame.location().declaringType().name()) || !AGENT_INVOKE_METHOD.equals(n = frame.location().method().name()) && !AGENT_VARVALUE_METHOD.equals(n)) continue;
                    ObjectReference thiz = frame.thisObject();
                    if (myRef != null && myRef != thiz) continue block6;
                    if (((BooleanValue)thiz.getValue(thiz.referenceType().fieldByName("inClientCode"))).value()) {
                        thiz.setValue(thiz.referenceType().fieldByName("expectingStop"), this.vm.mirrorOf(true));
                        ObjectReference stopInstance = (ObjectReference)thiz.getValue(thiz.referenceType().fieldByName("stopException"));
                        this.vm.resume();
                        thread.stop(stopInstance);
                        thiz.setValue(thiz.referenceType().fieldByName("expectingStop"), this.vm.mirrorOf(false));
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.vm.resume();
        }
        return false;
    }

    @Override
    public synchronized void closeStreams() {
        if (this.shellConnection == null) {
            return;
        }
        super.closeStreams();
        try {
            OutputStream os = this.shellConnection.getAgentInput();
            os.close();
        }
        catch (IOException os) {
            // empty catch block
        }
        try {
            InputStream is = this.shellConnection.getAgentOutput();
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.requestShutdown();
    }

    @Override
    protected ObjectReference getAgentObjectReference() {
        return this.shellConnection.getAgentHandle();
    }

    @Override
    public boolean requestShutdown() {
        this.agent.closeConnection(this.shellConnection);
        return false;
    }

    @Override
    public void connectionInitiated(ShellLaunchEvent ev) {
    }

    @Override
    public void handshakeCompleted(ShellLaunchEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ShellLaunchEvent ev) {
        DebugExecutionEnvironment debugExecutionEnvironment = this;
        synchronized (debugExecutionEnvironment) {
            if (ev.getConnection() != this.shellConnection || this.closed) {
                return;
            }
            this.closed = true;
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentDestroyed(ShellLaunchEvent ev) {
        DebugExecutionEnvironment debugExecutionEnvironment = this;
        synchronized (debugExecutionEnvironment) {
            if (ev.getAgent() != this.agent || this.closed) {
                return;
            }
            this.closed = true;
        }
        this.shutdown();
    }
}

