/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryCondition;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultRetryCondition
implements RetryCondition {
    private static final Map<Integer, Set<String>> RETRYABLE_SERVICE_ERRORS;
    private static final String PROCESSING_EXCEPTION_MSG = "[.|\\s\\S]*processing(\\s)+exception[.|\\s\\S]*";

    @Override
    public boolean shouldBeRetried(@Nonnull BmcException exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        return exception.isClientSide() || exception.isTimeout() || exception.getStatusCode() == 429 || exception.getStatusCode() == 500 || exception.getStatusCode() == 502 || exception.getStatusCode() == 503 || exception.getStatusCode() == 504 || RETRYABLE_SERVICE_ERRORS.containsKey(exception.getStatusCode()) && RETRYABLE_SERVICE_ERRORS.get(exception.getStatusCode()).contains(exception.getServiceCode()) || DefaultRetryCondition.isProcessingException(exception) || exception.getCause() instanceof CallNotAllowedException;
    }

    public static boolean isProcessingException(BmcException exception) {
        return exception.getStatusCode() == -1 && exception.getMessage().toLowerCase().matches(PROCESSING_EXCEPTION_MSG);
    }

    static {
        HashMap<Integer, Set<String>> temp = new HashMap<Integer, Set<String>>();
        temp.put(409, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("IncorrectState"))));
        RETRYABLE_SERVICE_ERRORS = Collections.unmodifiableMap(temp);
    }
}

