/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.neon.completion;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;

public interface NeonElement
extends ElementHandle {
    public String getTemplate();

    public String getType();

    public static final class NeonTypedElement
    extends BaseNeonElementItem {
        private final String template;
        private final String type;

        private NeonTypedElement(String name, String type, String template) {
            super(name);
            this.template = template;
            this.type = type;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    public static final class NeonExtendedElement
    extends BaseNeonElementItem {
        private final String template;

        private NeonExtendedElement(String name, String template) {
            super(name);
            this.template = template;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }
    }

    public static final class NeonSimpleElement
    extends BaseNeonElementItem {
        private NeonSimpleElement(String name) {
            super(name);
        }

        @Override
        public String getTemplate() {
            return this.getName();
        }
    }

    public static abstract class BaseNeonElementItem
    implements NeonElement {
        private final String name;

        public BaseNeonElementItem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        @Override
        public String getType() {
            return this.getTemplate();
        }
    }

    public static class Factory {
        private static final String NAMESPACE_SEPARATOR = "\\";

        public static NeonElement create(String name) {
            return new NeonSimpleElement(name);
        }

        public static NeonElement createType(String typeName) {
            String[] nameParts = typeName.split("\\\\");
            String unqualifiedName = nameParts[nameParts.length - 1];
            return new NeonExtendedElement(unqualifiedName, typeName.startsWith(NAMESPACE_SEPARATOR) ? typeName.substring(1) : typeName);
        }

        public static NeonElement createMethod(String methodName, String typeName) {
            return new NeonTypedElement(methodName, typeName, typeName + "::" + methodName);
        }

        public static NeonElement create(String name, String template) {
            return new NeonExtendedElement(name, template);
        }
    }
}

