/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenProxySupport;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.MavenModelProblemsProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class SanityBuildAction
implements ProjectProblemResolver {
    private static final Logger LOG = Logger.getLogger(SanityBuildAction.class.getName());
    private final Project nbproject;
    private final Supplier<Boolean> checkSupplier;
    private volatile CompletableFuture<ProjectProblemsProvider.Result> pendingResult;

    public SanityBuildAction(Project nbproject, Supplier<Boolean> checkSupplier) {
        this.nbproject = nbproject;
        this.checkSupplier = checkSupplier;
    }

    public SanityBuildAction(Project nbproject, Supplier<Boolean> checkSupplier, Future<ProjectProblemsProvider.Result> otherResult) {
        this.nbproject = nbproject;
        this.checkSupplier = checkSupplier;
    }

    public Future<ProjectProblemsProvider.Result> getPendingResult() {
        return this.pendingResult;
    }

    public CompletableFuture<ProjectProblemsProvider.Result> resolve() {
        return this.resolve(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ProjectProblemsProvider.Result> resolve(final Lookup context) {
        CompletableFuture<ProjectProblemsProvider.Result> pr = this.pendingResult;
        if (pr != null && !pr.isDone()) {
            LOG.log(Level.FINE, "SanityBuild.resolve returns: {0}", this.pendingResult);
            return this.pendingResult;
        }
        final CompletableFuture<ProjectProblemsProvider.Result> publicResult = new CompletableFuture<ProjectProblemsProvider.Result>();
        final AtomicReference primingResult = new AtomicReference();
        final AtomicReference primingException = new AtomicReference();
        Runnable toRet = new Runnable(){
            final /* synthetic */ SanityBuildAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ProjectProblemsProvider.Result r;
                if (!this.this$0.checkSupplier.get().booleanValue() && (r = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)Bundle.ACT_start_validate())) != null) {
                    LOG.log(Level.FINE, "Project {0} is OK before sanity build action.", this.this$0.nbproject);
                    publicResult.complete(r);
                    return;
                }
                try {
                    LOG.log(Level.FINE, "Configuring sanity build");
                    AtomicInteger result = new AtomicInteger();
                    BeanRunConfig config = new BeanRunConfig();
                    if (context != null) {
                        config.setActionContext(context);
                    }
                    config.setExecutionDirectory(FileUtil.toFile((FileObject)this.this$0.nbproject.getProjectDirectory()));
                    NbMavenProject mavenPrj = (NbMavenProject)this.this$0.nbproject.getLookup().lookup(NbMavenProject.class);
                    MavenProject loaded = NbMavenProject.getPartialProject(mavenPrj.getMavenProject());
                    String goals = mavenPrj != null && mavenPrj.getMavenProject().getVersion() != null && mavenPrj.getMavenProject().getVersion().endsWith("SNAPSHOT") ? NbPreferences.forModule(MavenSettings.class).get("primingBuild.snapshot.goals", "install") : NbPreferences.forModule(MavenSettings.class).get("primingBuild.regular.goals", "package");
                    config.setGoals(Arrays.asList("--fail-at-end", goals));
                    config.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE);
                    config.setProperty("skipTests", "true");
                    config.setProject(this.this$0.nbproject);
                    String label = Bundle.build_label(this.this$0.nbproject.getProjectDirectory().getNameExt());
                    config.setExecutionName(label);
                    config.setTaskDisplayName(label);
                    config.setInternalProperty(SanityBuildAction.class.getName(), result);
                    MavenProxySupport mps = (MavenProxySupport)this.this$0.nbproject.getLookup().lookup(MavenProxySupport.class);
                    if (mps != null) {
                        try {
                            MavenProxySupport.ProxyResult res = mps.checkProxySettings().get();
                            if (res.getStatus() == MavenProxySupport.Status.ABORT) {
                                ProjectProblemsProvider.Result r2 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_SanityBuildCancalled());
                                primingResult.set(r2);
                                return;
                            }
                        }
                        catch (ExecutionException ex) {
                            ProjectProblemsProvider.Result r3 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_ProxyUpdateFailed(ex.getLocalizedMessage()));
                            primingResult.set(r3);
                            return;
                        }
                        catch (InterruptedException ex) {
                            ProjectProblemsProvider.Result r4 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_SanityBuildCancalled());
                            primingResult.set(r4);
                            return;
                        }
                    }
                    long t = System.currentTimeMillis();
                    LOG.log(Level.FINE, "Executing sanity build: goals = {0}, properties = {1}", new Object[]{config.getGoals(), config.getProperties()});
                    ExecutorTask et = RunUtils.run(config);
                    AtomicBoolean stopped = new AtomicBoolean();
                    if (et != null) {
                        publicResult.exceptionally(x -> {
                            if (x instanceof CancellationException) {
                                stopped.set(true);
                                et.stop();
                            }
                            return null;
                        });
                        et.waitFinished();
                        ProjectProblemsProvider.Result r5 = !stopped.get() && (result.get() == 0 || !((SanityBuildNeededChecker)this.this$0.nbproject.getLookup().lookup(SanityBuildNeededChecker.class)).isSanityBuildNeeded()) ? ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)Bundle.ACT_PrimingComplete()) : ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ACT_PrimingFailed());
                        LOG.log(Level.FINE, "Sanity build of {0} finished, took {1} ms.", new Object[]{this.this$0.nbproject, System.currentTimeMillis() - t});
                        primingResult.set(r5);
                    }
                }
                catch (Error | RuntimeException e) {
                    LOG.log(Level.FINE, "Sanity build failed", e);
                    primingException.set(e);
                    throw e;
                }
            }
        };
        SanityBuildAction sanityBuildAction = this;
        synchronized (sanityBuildAction) {
            if (this.pendingResult != pr) {
                return this.pendingResult;
            }
            this.pendingResult = publicResult;
        }
        ((NbMavenProjectImpl)this.nbproject).scheduleProjectOperation(MavenModelProblemsProvider.RP, toRet, 0, true).addTaskListener(l -> {
            if (primingException.get() != null) {
                publicResult.completeExceptionally((Throwable)primingException.get());
            } else {
                publicResult.complete((ProjectProblemsProvider.Result)primingResult.get());
            }
        });
        return publicResult;
    }

    public int hashCode() {
        int hash = SanityBuildAction.class.hashCode();
        hash = 67 * hash + (this.nbproject != null ? this.nbproject.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SanityBuildAction other = (SanityBuildAction)obj;
        return this.nbproject == other.nbproject || this.nbproject != null && this.nbproject.equals((Object)other.nbproject);
    }

    public static interface SanityBuildNeededChecker {
        public boolean isSanityBuildNeeded();
    }

    public static class ResultChecker
    implements ExecutionResultChecker {
        @Override
        public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
            Object resultObj = config.getInternalProperties().get(SanityBuildAction.class.getName());
            if (!(resultObj instanceof AtomicInteger)) {
                return;
            }
            AtomicInteger result = (AtomicInteger)resultObj;
            result.set(resultCode);
        }
    }
}

