/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extexecution.base.WrapperProcess;
import org.netbeans.spi.extexecution.base.ProcessesImplementation;
import org.openide.util.Lookup;

public final class Processes {
    private static final Logger LOGGER = Logger.getLogger(Processes.class.getName());

    private Processes() {
    }

    public static void killTree(Process process, Map<String, String> environment) {
        if (process instanceof WrapperProcess) {
            Processes.killTree(((WrapperProcess)process).getDelegate(), environment);
            return;
        }
        for (ProcessesImplementation impl : Lookup.getDefault().lookupAll(ProcessesImplementation.class)) {
            try {
                impl.killTree(process, environment);
                LOGGER.log(Level.FINE, "Process tree killed using {0}", impl.getClass().getName());
                break;
            }
            catch (UnsupportedOperationException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        process.destroy();
    }
}

