/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;

final class RemoteMeasurements {
    private static final ConcurrentHashMap<Integer, String> stacks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Stat> stats = new ConcurrentHashMap();
    private final AtomicLong upTraffic = new AtomicLong();
    private final AtomicLong downTraffic = new AtomicLong();
    private final String name;
    private final long startWallTime;

    RemoteMeasurements(String name) {
        this.name = "'" + name + "'";
        this.startWallTime = System.currentTimeMillis();
    }

    public RemoteStatistics.ActivityID startChannelActivity(CharSequence category, CharSequence ... args) {
        Stat stat = new Stat(category, args);
        int hashCode = stat.hashCode();
        Stat prevStat = this.stats.putIfAbsent(hashCode, stat);
        if (prevStat != null) {
            stat = prevStat;
        }
        stat.count.incrementAndGet();
        return new StatKey(hashCode, System.currentTimeMillis());
    }

    public void stopChannelActivity(Object activityID) {
        this.stopChannelActivity(activityID, 0L);
    }

    public void stopChannelActivity(Object activityID, long supposedTraffic) {
        StatKey key = (StatKey)activityID;
        Stat stat = this.stats.get(key.statID);
        assert (stat != null);
        stat.deltaTime.addAndGet(System.currentTimeMillis() - key.startTime);
        stat.supposedTraffic.addAndGet(supposedTraffic);
    }

    void dump(PrintStream out) {
        try {
            this.dumpTrafficStatistics(out);
            this.dumpCategoriesStatistics(out);
            this.dumpCategoriesArgsStatistics(out);
            this.dumpCategoriesStacksStatistics(out);
        }
        catch (Throwable throwable) {
            out.printf("Total wall time 20%s [ms]: %8d\n", this.name, System.currentTimeMillis() - this.startWallTime);
            throw throwable;
        }
        out.printf("Total wall time 20%s [ms]: %8d\n", this.name, System.currentTimeMillis() - this.startWallTime);
    }

    private void dumpTrafficStatistics(PrintStream out) {
        out.printf("Upload traffic   %20s [bytes]: %10d\n", this.name, this.upTraffic.get());
        out.printf("Download traffic %20s [bytes]: %10d\n", this.name, this.downTraffic.get());
    }

    private void dumpCategoriesArgsStatistics(PrintStream out) {
        HashMap<String, Counters> data = new HashMap<String, Counters>();
        for (Stat stat : this.stats.values()) {
            String string = stat.category + "%" + Arrays.toString(stat.args);
            Counters counters = (Counters)data.get(string);
            if (counters == null) {
                counters = new Counters();
                data.put(string, counters);
            }
            counters.add(stat);
        }
        out.printf("== Arguments statistics start ==\n", new Object[0]);
        out.printf("%20s|%8s|%8s|%10s|%s\n", "Category", "Count", "Time", "~Traffic", "Args");
        LinkedList dataList = new LinkedList(data.entrySet());
        dataList.sort(new CategoriesStatComparator());
        for (Map.Entry entry : dataList) {
            String cat = (String)entry.getKey();
            int idx = cat.indexOf(37);
            Counters cnts = (Counters)entry.getValue();
            out.printf("%20s|%8d|%8d|%10d|%s\n", cat.substring(0, idx), cnts.count.get(), cnts.time.get(), cnts.supposedTraffic.get(), cat.substring(idx + 1));
        }
        out.printf("== Arguments statistics end ==\n", new Object[0]);
    }

    private void dumpCategoriesStacksStatistics(PrintStream out) {
        HashMap<String, Counters> data = new HashMap<String, Counters>();
        for (Stat stat : this.stats.values()) {
            String string = stat.stackID + "%" + stat.category;
            Counters counters = (Counters)data.get(string);
            if (counters == null) {
                counters = new Counters();
                data.put(string, counters);
            }
            counters.add(stat);
        }
        out.printf("== Categories stacks statistics start ==\n", new Object[0]);
        out.printf("%20s|%8s|%8s|%10s|%s\n", "Category", "Count", "Time", "~Traffic", "Args");
        LinkedList dataList = new LinkedList(data.entrySet());
        dataList.sort(new CategoriesStatComparator());
        for (Map.Entry entry : dataList) {
            String cat = (String)entry.getKey();
            int idx = cat.indexOf(37);
            Counters cnts = (Counters)entry.getValue();
            Integer stackID = Integer.valueOf(cat.substring(0, idx));
            String category = cat.substring(idx + 1);
            out.printf("%20s|%8d|%8d|%10d|%s\n", category, cnts.count.get(), cnts.time.get(), cnts.supposedTraffic.get(), stacks.get(stackID));
        }
        out.printf("== Categories stacks statistics end ==\n", new Object[0]);
    }

    private void dumpCategoriesStatistics(PrintStream out) {
        long totalTime = 0L;
        long totalTraffic = 0L;
        HashMap<String, Counters> map = new HashMap<String, Counters>();
        for (Stat stat : this.stats.values()) {
            Counters counters = (Counters)map.get(stat.category);
            if (counters == null) {
                counters = new Counters();
                map.put(stat.category, counters);
            }
            counters.add(stat);
        }
        out.printf("== Categories stat begin ==\n", new Object[0]);
        out.printf("%20s|%8s|%8s|%10s|%s\n", "Category", "Count", "Time", "~Traffic", "Args");
        for (Map.Entry entry : map.entrySet()) {
            long dt = ((Counters)entry.getValue()).time.get();
            long supposedTraffic = ((Counters)entry.getValue()).supposedTraffic.get();
            out.printf("%20s|%8d|%8d|%s\n", entry.getKey(), ((Counters)entry.getValue()).count.get(), dt, supposedTraffic, ((Counters)entry.getValue()).args.size());
            totalTime += dt;
        }
        out.printf("== Categories stat end ==\n", new Object[0]);
        out.printf("Total time by all categories [ms]:                %20d\n", totalTime);
        out.printf("Total supposed traffic by all categories [bytes]: %20d\n", totalTraffic);
    }

    private static int getStackID() {
        if (!RemoteStatistics.COLLECT_STACKS) {
            return -1;
        }
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null) {
            String prevFile = null;
            for (int i = stackTrace.length - 1; i >= 0; --i) {
                StackTraceElement st = stackTrace[i];
                String filename = st.getFileName();
                String curFile = filename.substring(0, filename.lastIndexOf(46));
                sb.append(curFile.equals(prevFile) ? "" : curFile).append(':').append(st.getLineNumber()).append(';');
                prevFile = curFile;
                String className = st.getClassName();
                if (!className.startsWith("com.jcraft.jsch")) continue;
                sb.append("...");
                break;
            }
        }
        String stack = sb.toString();
        Integer stackID = stack.hashCode();
        stacks.putIfAbsent(stackID, stack);
        return stackID;
    }

    void bytesUploaded(int bytes) {
        this.upTraffic.addAndGet(bytes);
    }

    void bytesDownloaded(int bytes) {
        this.downTraffic.addAndGet(bytes);
    }

    private static final class Stat {
        private final String category;
        private final String[] args;
        private final int stackID;
        private final AtomicLong deltaTime = new AtomicLong(0L);
        private final AtomicLong count = new AtomicLong(0L);
        private final AtomicLong supposedTraffic = new AtomicLong(0L);

        public Stat(CharSequence category, CharSequence ... args) {
            this.stackID = RemoteMeasurements.getStackID();
            this.category = category.toString();
            if (args == null) {
                this.args = null;
            } else {
                this.args = new String[args.length];
                int i = 0;
                for (CharSequence arg : args) {
                    this.args[i++] = arg.toString();
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Stat other = (Stat)obj;
            if (this.stackID != other.stackID) {
                return false;
            }
            if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
                return false;
            }
            return Arrays.deepEquals(this.args, other.args);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.stackID;
            hash = 79 * hash + (this.category != null ? this.category.hashCode() : 0);
            hash = 79 * hash + Arrays.deepHashCode(this.args);
            return hash;
        }
    }

    private static final class StatKey
    extends RemoteStatistics.ActivityID {
        private final int statID;
        private final long startTime;

        private StatKey(int statID, long startTime) {
            this.statID = statID;
            this.startTime = startTime;
        }
    }

    private static final class Counters {
        private final AtomicLong count = new AtomicLong();
        private final AtomicLong time = new AtomicLong();
        private final AtomicLong supposedTraffic = new AtomicLong();
        private final HashSet<Integer> args = new HashSet();

        private Counters() {
        }

        private void add(Stat stat) {
            this.count.addAndGet(stat.count.get());
            this.time.addAndGet(stat.deltaTime.get());
            this.args.add(Arrays.deepHashCode(stat.args));
            this.supposedTraffic.addAndGet(stat.supposedTraffic.get());
        }
    }

    private static class CategoriesStatComparator
    implements Comparator<Map.Entry<String, Counters>> {
        private CategoriesStatComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Counters> o1, Map.Entry<String, Counters> o2) {
            long o2Val;
            String s1 = o1.getKey();
            String s2 = o2.getKey();
            int idx1 = s1.indexOf(37);
            int idx2 = s2.indexOf(37);
            int cmp = s1.substring(0, idx1).compareTo(s2.substring(0, idx2));
            if (cmp != 0) {
                return cmp;
            }
            long o1Val = o1.getValue().time.get();
            return o1Val < (o2Val = o2.getValue().time.get()) ? 1 : (o1Val == o2Val ? 0 : -1);
        }
    }
}

