/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeSubnetCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeSubnetCompartmentRequest
extends BmcRequest<ChangeSubnetCompartmentDetails> {
    private String subnetId;
    private ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getSubnetId() {
        return this.subnetId;
    }

    public ChangeSubnetCompartmentDetails getChangeSubnetCompartmentDetails() {
        return this.changeSubnetCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeSubnetCompartmentDetails getBody$() {
        return this.changeSubnetCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().subnetId(this.subnetId).changeSubnetCompartmentDetails(this.changeSubnetCompartmentDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subnetId=").append(String.valueOf(this.subnetId));
        sb.append(",changeSubnetCompartmentDetails=").append(String.valueOf((Object)this.changeSubnetCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeSubnetCompartmentRequest)) {
            return false;
        }
        ChangeSubnetCompartmentRequest other = (ChangeSubnetCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals((Object)this.changeSubnetCompartmentDetails, (Object)other.changeSubnetCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.changeSubnetCompartmentDetails == null ? 43 : this.changeSubnetCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subnetId = null;
        private ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder changeSubnetCompartmentDetails(ChangeSubnetCompartmentDetails changeSubnetCompartmentDetails) {
            this.changeSubnetCompartmentDetails = changeSubnetCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSubnetCompartmentRequest o) {
            this.subnetId(o.getSubnetId());
            this.changeSubnetCompartmentDetails(o.getChangeSubnetCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSubnetCompartmentRequest build() {
            ChangeSubnetCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeSubnetCompartmentDetails body) {
            this.changeSubnetCompartmentDetails(body);
            return this;
        }

        public ChangeSubnetCompartmentRequest buildWithoutInvocationCallback() {
            ChangeSubnetCompartmentRequest request = new ChangeSubnetCompartmentRequest();
            request.subnetId = this.subnetId;
            request.changeSubnetCompartmentDetails = this.changeSubnetCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

