/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.editor.lexer;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.docker.editor.lexer.DockerfileTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

final class DockerfileLexer
implements Lexer<DockerfileTokenId> {
    private static final int STATE_NEW_LINE = 0;
    private static final int STATE_CONT_LINE = 1;
    private static final int STATE_ONBUILD = 2;
    private static final int STATE_REST = 3;
    private static final int STATE_ESCAPE = 4;
    private static final Map<String, DockerfileTokenId> KW_TO_TKN;
    private static final Set<DockerfileTokenId> KW_ON_BUILD;
    private final LexerInput input;
    private final TokenFactory<DockerfileTokenId> tokenFactory;
    private Integer state = null;
    private int previousLength = -1;
    private int currentLength = -1;

    DockerfileLexer(@NonNull LexerRestartInfo<DockerfileTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        Object restoredState = info.state();
        if (restoredState instanceof Integer) {
            this.state = (Integer)restoredState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Token<DockerfileTokenId> nextToken() {
        if (this.state == null) {
            this.state = 0;
        }
        int currentState = this.state;
        int[] newStateHolder = new int[]{this.state == 4 ? 3 : this.state};
        int c = this.nextChar();
        try {
            Token<DockerfileTokenId> t;
            switch (c) {
                case 10: 
                case 13: {
                    newStateHolder[0] = currentState == 4 ? 1 : 0;
                }
                case 9: 
                case 11: 
                case 12: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    Token<DockerfileTokenId> token = this.finishWhitespace(currentState, newStateHolder);
                    return token;
                }
                case 32: {
                    c = this.nextChar();
                    if (c == -1 || !Character.isWhitespace(c)) {
                        this.backup(1);
                        Token token = this.input.readLength() == 1 ? this.tokenFactory.getFlyweightToken((TokenId)DockerfileTokenId.WHITESPACE, " ") : this.tokenFactory.createToken((TokenId)DockerfileTokenId.WHITESPACE);
                        return token;
                    }
                    this.backup(1);
                    Token<DockerfileTokenId> token = this.finishWhitespace(currentState, newStateHolder);
                    return token;
                }
                case -1: {
                    Token<DockerfileTokenId> token = null;
                    return token;
                }
                case 91: {
                    newStateHolder[0] = 3;
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.LBRACKET);
                    return token;
                }
                case 93: {
                    newStateHolder[0] = 3;
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.RBRACKET);
                    return token;
                }
                case 44: {
                    newStateHolder[0] = 3;
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.COMMA);
                    return token;
                }
                case 35: {
                    if (currentState == 0 || currentState == 1) {
                        while (true) {
                            switch (this.nextChar()) {
                                case 13: {
                                    this.consumeNewline();
                                }
                                case -1: 
                                case 10: {
                                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.LINE_COMMENT);
                                    return token;
                                }
                            }
                        }
                    }
                    newStateHolder[0] = 3;
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.IDENTIFIER);
                    return token;
                }
                case 39: {
                    newStateHolder[0] = 3;
                    if (currentState != 4) {
                        Token<DockerfileTokenId> token = this.finishString('\'', '\"', newStateHolder);
                        return token;
                    }
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.IDENTIFIER);
                    return token;
                }
                case 34: {
                    newStateHolder[0] = 3;
                    if (currentState != 4) {
                        Token<DockerfileTokenId> token = this.finishString('\"', '\'', newStateHolder);
                        return token;
                    }
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.IDENTIFIER);
                    return token;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    newStateHolder[0] = 3;
                    Token<DockerfileTokenId> token = this.finishNumber(this.nextChar());
                    return token;
                }
                case 92: {
                    newStateHolder[0] = 4;
                    Token<DockerfileTokenId> token = this.token(DockerfileTokenId.ESCAPE);
                    return token;
                }
            }
            if (DockerfileLexer.isIdentifierStart(c, currentState)) {
                while ((c = this.nextChar()) != -1 && DockerfileLexer.isIdentifierPart(c, currentState)) {
                }
                this.backup(1);
                t = this.keywordOrIdentifier(currentState);
            } else {
                t = this.token(DockerfileTokenId.IDENTIFIER);
            }
            newStateHolder[0] = t.id() == DockerfileTokenId.ONBUILD ? 2 : 3;
            Token<DockerfileTokenId> token = t;
            return token;
        }
        finally {
            this.state = newStateHolder[0];
        }
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    @NonNull
    private Token<DockerfileTokenId> token(DockerfileTokenId id) {
        String fixedText = id.fixedText();
        return fixedText != null && fixedText.length() == this.input.readLength() ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : this.tokenFactory.createToken((TokenId)id);
    }

    private int nextChar() {
        this.previousLength = this.currentLength;
        int c = this.input.read();
        this.currentLength = 1;
        return c;
    }

    public void backup(int howMany) {
        switch (howMany) {
            case 1: {
                assert (this.currentLength != -1);
                this.input.backup(this.currentLength);
                this.currentLength = this.previousLength;
                this.previousLength = -1;
                break;
            }
            case 2: {
                assert (this.currentLength != -1 && this.previousLength != -1);
                this.input.backup(this.currentLength + this.previousLength);
                this.previousLength = -1;
                this.currentLength = -1;
                break;
            }
            default: {
                assert (false) : howMany;
                break;
            }
        }
    }

    private void consumeNewline() {
        if (this.nextChar() != 10) {
            this.backup(1);
        }
    }

    private Token<DockerfileTokenId> finishWhitespace(int currentState, int[] stateHolder) {
        block4: while (true) {
            int c = this.nextChar();
            switch (c) {
                case 10: 
                case 13: {
                    stateHolder[0] = currentState == 4 ? 1 : 0;
                    continue block4;
                }
                case 9: 
                case 11: 
                case 12: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    continue block4;
                }
            }
            break;
        }
        this.backup(1);
        return this.tokenFactory.createToken((TokenId)DockerfileTokenId.WHITESPACE);
    }

    @NonNull
    private Token<DockerfileTokenId> finishString(char closingChar, char otherStringChar, int[] stateHolder) {
        boolean inEscapeBlock = false;
        boolean escapeBlockAllowed = true;
        block3: while (true) {
            int c;
            if ((c = this.nextChar()) == 13) {
                stateHolder[0] = 0;
                this.consumeNewline();
                return this.tokenFactory.createToken((TokenId)DockerfileTokenId.STRING_LITERAL, this.input.readLength(), PartType.START);
            }
            if (c == 10) {
                stateHolder[0] = 0;
                return this.tokenFactory.createToken((TokenId)DockerfileTokenId.STRING_LITERAL, this.input.readLength(), PartType.START);
            }
            if (c == -1) {
                return this.tokenFactory.createToken((TokenId)DockerfileTokenId.STRING_LITERAL, this.input.readLength(), PartType.START);
            }
            if (c == closingChar) {
                if (inEscapeBlock) continue;
                return this.token(DockerfileTokenId.STRING_LITERAL);
            }
            if (c == otherStringChar && escapeBlockAllowed) {
                inEscapeBlock = !inEscapeBlock;
                continue;
            }
            if (c == 35) {
                escapeBlockAllowed = false;
                continue;
            }
            if (c != 92) continue;
            boolean followedBySpace = false;
            c = this.nextChar();
            while (DockerfileLexer.isSpaceOnLine(c)) {
                followedBySpace = true;
                c = this.nextChar();
            }
            if (!followedBySpace) continue;
            switch (c) {
                case 10: 
                case 13: {
                    continue block3;
                }
            }
            this.backup(1);
        }
    }

    @NonNull
    private Token<DockerfileTokenId> finishNumber(int c) {
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    break;
                }
                default: {
                    this.backup(1);
                    return this.token(DockerfileTokenId.NUMBER_LITERAL);
                }
            }
            c = this.nextChar();
        }
    }

    @NonNull
    private Token<DockerfileTokenId> keywordOrIdentifier(int currentState) {
        DockerfileTokenId id = DockerfileLexer.filter(KW_TO_TKN.get(this.input.readText().toString().toUpperCase()), currentState);
        if (id == null) {
            id = DockerfileTokenId.IDENTIFIER;
        }
        return this.token(id);
    }

    @CheckForNull
    private static DockerfileTokenId filter(@NullAllowed DockerfileTokenId id, int currentState) {
        switch (currentState) {
            case 0: {
                return id;
            }
            case 2: {
                return KW_ON_BUILD.contains((Object)id) ? id : null;
            }
        }
        return null;
    }

    private static boolean isIdentifierStart(int c, int currentState) {
        return Character.isJavaIdentifierStart(c) || c == 35 && currentState != 0 && currentState != 1;
    }

    private static boolean isIdentifierPart(int c, int currentState) {
        return Character.isJavaIdentifierPart(c) || c == 46 || c == 45 || c == 95 || c == 35 && currentState != 0 && currentState != 1;
    }

    private static boolean isSpaceOnLine(int c) {
        switch (c) {
            case 9: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    static {
        HashMap<String, DockerfileTokenId> m = new HashMap<String, DockerfileTokenId>();
        EnumSet<DockerfileTokenId> s = EnumSet.noneOf(DockerfileTokenId.class);
        for (DockerfileTokenId id : DockerfileTokenId.values()) {
            if (id.fixedText() == null || !DockerfileTokenId.language().tokenCategories((TokenId)id).contains("keyword")) continue;
            m.put(id.fixedText(), id);
            if (!id.isOnBuildSupported()) continue;
            s.add(id);
        }
        KW_TO_TKN = Collections.unmodifiableMap(m);
        KW_ON_BUILD = Collections.unmodifiableSet(s);
    }
}

