/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.api.beans.model.SpringMetaModelSupport;
import org.netbeans.modules.spring.api.beans.model.SpringModel;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.SpringConfigModelAccessor;
import org.netbeans.modules.spring.beans.SpringScopeAccessor;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class SpringScope {
    private final ConfigFileManager configFileManager;
    private final SpringConfigFileModelManager fileModelManager = new SpringConfigFileModelManager();
    private MetadataModel<SpringModel> springAnnotationModel = null;

    private SpringScope(ConfigFileManager configFileManager) {
        this.configFileManager = configFileManager;
    }

    public static SpringScope getSpringScope(FileObject fo) {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        ProjectSpringScopeProvider provider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getSpringScope();
    }

    public ConfigFileManager getConfigFileManager() {
        return this.configFileManager;
    }

    public List<SpringConfigModel> getAllConfigModels() {
        final ArrayList groups = new ArrayList();
        final ArrayList files = new ArrayList();
        this.configFileManager.mutex().readAccess(new Runnable(){
            final /* synthetic */ SpringScope this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                groups.addAll(this.this$0.configFileManager.getConfigFileGroups());
                files.addAll(this.this$0.configFileManager.getConfigFiles());
            }
        });
        ArrayList<SpringConfigModel> result = new ArrayList<SpringConfigModel>(groups.size());
        HashSet<File> modelFiles = new HashSet<File>(groups.size() * 2);
        for (ConfigFileGroup group : groups) {
            result.add(SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, group));
            modelFiles.addAll(group.getFiles());
        }
        TreeSet nonModelFiles = new TreeSet(files);
        nonModelFiles.removeAll(modelFiles);
        for (File file : nonModelFiles) {
            ConfigFileGroup singleFileGroup = ConfigFileGroup.create(Collections.singletonList(file));
            result.add(SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, singleFileGroup));
        }
        return Collections.unmodifiableList(result);
    }

    public MetadataModel<SpringModel> getSpringAnnotationModel(FileObject fo) {
        if (this.springAnnotationModel == null) {
            Project project = SpringScope.getSpringProject(fo);
            if (project == null) {
                return null;
            }
            SpringMetaModelSupport metaModelSupport = new SpringMetaModelSupport(project);
            this.springAnnotationModel = metaModelSupport.getMetaModel();
        }
        return this.springAnnotationModel;
    }

    private SpringConfigModel getConfigModel(FileObject configFO) {
        File configFile = FileUtil.toFile((FileObject)configFO);
        if (configFile == null) {
            return null;
        }
        SpringConfigModel model = this.getGroupConfigModel(configFile);
        if (model != null) {
            return model;
        }
        return this.getFileConfigModel(configFO);
    }

    private SpringConfigModel getGroupConfigModel(File configFile) {
        for (ConfigFileGroup group : this.configFileManager.getConfigFileGroups()) {
            if (!group.containsFile(configFile)) continue;
            return SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, group);
        }
        return null;
    }

    private SpringConfigModel getFileConfigModel(FileObject configFO) {
        File configFile = FileUtil.toFile((FileObject)configFO);
        if (configFile != null) {
            ConfigFileGroup singleFileGroup = ConfigFileGroup.create(Collections.singletonList(configFile));
            return SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, singleFileGroup);
        }
        return null;
    }

    private static Project getSpringProject(FileObject fo) {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        ProjectSpringScopeProvider provider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getProject();
    }

    static {
        SpringScopeAccessor.setDefault(new SpringScopeAccessor(){

            @Override
            public SpringScope createSpringScope(ConfigFileManager configFileManager) {
                return new SpringScope(configFileManager);
            }

            @Override
            public SpringConfigModel getConfigModel(SpringScope scope, FileObject fo) {
                return scope.getConfigModel(fo);
            }
        });
    }
}

