/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.formatters.Formatters;
import org.netbeans.modules.debugger.jpda.expr.formatters.FormattersLoopControl;
import org.netbeans.modules.debugger.jpda.expr.formatters.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTableModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class VariablesFormatterFilter
extends VariablesFilterAdapter {
    static Map<Object, String> FORMATTED_CHILDREN_VARS = new WeakHashMap<Object, String>();
    private VariablesFormatter[] formattersWithExpandTestCode;
    private final Object formattersLock = new Object();
    private Properties jpdaProperties;
    private PropertyChangeListener formattersChangeListener;
    private boolean formattersLoopWarned = false;
    private final Map<ObjectVariable, Boolean> childrenExpandTest = new WeakHashMap<ObjectVariable, Boolean>();
    private final Set<ObjectVariable> childrenExpandTestProcessing = new HashSet<ObjectVariable>();
    private final RequestProcessor expandTestProcessor = new RequestProcessor("Variables expand test processor", 1);
    private final ContextProvider lookupProvider;
    private VariablesTreeModelFilter vtmf;
    private static HashSet leafType;
    private static HashSet toStringValueType;

    public VariablesFormatterFilter(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    private VariablesFormatter[] getFormatters() {
        Formatters formatters = Formatters.getDefault();
        if (this.formattersChangeListener == null) {
            this.formattersChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("formatters".equals(evt.getPropertyName())) {
                        Object object = VariablesFormatterFilter.this.formattersLock;
                        synchronized (object) {
                            VariablesFormatterFilter.access$102(VariablesFormatterFilter.this, null);
                            VariablesFormatterFilter.this.childrenExpandTest.clear();
                        }
                    }
                }
            };
            formatters.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.formattersChangeListener, (Object)formatters));
        }
        return formatters.getFormatters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariablesFormatter[] getFormattersWithExpandTestCode() {
        Object object = this.formattersLock;
        synchronized (object) {
            if (this.formattersWithExpandTestCode == null) {
                VariablesFormatter[] formatters = this.getFormatters();
                ArrayList<VariablesFormatter> formattersWithExpandTestCodeList = new ArrayList<VariablesFormatter>();
                for (VariablesFormatter vf : formatters) {
                    String expandTestCode = vf.getChildrenExpandTestCode();
                    if (expandTestCode == null || expandTestCode.length() <= 0) continue;
                    formattersWithExpandTestCodeList.add(vf);
                }
                this.formattersWithExpandTestCode = formattersWithExpandTestCodeList.toArray(new VariablesFormatter[0]);
            }
            return this.formattersWithExpandTestCode;
        }
    }

    public String[] getSupportedTypes() {
        VariablesFormatter[] formatters = this.getFormatters();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < formatters.length; ++i) {
            String[] ts;
            for (String t : ts = formatters[i].getClassTypes()) {
                types.add(t);
            }
        }
        return types.toArray(new String[0]);
    }

    public String[] getSupportedAncestors() {
        VariablesFormatter[] formatters = this.getFormatters();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < formatters.length; ++i) {
            String[] ts;
            if (!formatters[i].isIncludeSubTypes()) continue;
            for (String t : ts = formatters[i].getClassTypes()) {
                types.add(t);
            }
        }
        return types.toArray(new String[0]);
    }

    public Object[] getChildren(TreeModel original, Variable variable, int from, int to) throws UnknownTypeException {
        Object[] children = !(variable instanceof ObjectVariable) ? original.getChildren((Object)variable, from, to) : this.getChildren(original, variable, from, to, new FormattersLoopControl());
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getChildren(TreeModel original, Variable variable, int from, int to, FormattersLoopControl formatters) throws UnknownTypeException {
        if (variable instanceof ObjectVariable) {
            ObjectVariable ov = (ObjectVariable)variable;
            Set<ObjectVariable> set = this.childrenExpandTestProcessing;
            synchronized (set) {
                while (this.childrenExpandTestProcessing.contains(ov)) {
                    try {
                        this.childrenExpandTestProcessing.wait();
                    }
                    catch (InterruptedException ex) {
                        return new Object[0];
                    }
                }
            }
            if (Boolean.TRUE.equals(this.childrenExpandTest.get(ov))) {
                return new Object[0];
            }
            JPDAClassType ct = ov.getClassType();
            if (ct == null) {
                return original.getChildren((Object)variable, from, to);
            }
            VariablesFormatter f = Formatters.getFormatterForType((JPDAClassType)ct, (VariablesFormatter[])formatters.getFormatters());
            String[] formattersInLoopRef = new String[]{null};
            if (f != null && formatters.canUse(f, ct.getName(), formattersInLoopRef)) {
                if (f.isUseChildrenVariables()) {
                    Map chvs = f.getChildrenVariables();
                    Object[] ch = new Object[chvs.size()];
                    int i = 0;
                    for (String name : chvs.keySet()) {
                        try {
                            Method evaluateMethod = ov.getClass().getMethod("evaluate", String.class);
                            evaluateMethod.setAccessible(true);
                            Object var = evaluateMethod.invoke((Object)ov, chvs.get(name));
                            FORMATTED_CHILDREN_VARS.put(var, name);
                            ch[i++] = var;
                        }
                        catch (InvocationTargetException itex) {
                            Throwable t = itex.getTargetException();
                            if (!(t instanceof InvalidExpressionException)) {
                                Exceptions.printStackTrace((Throwable)t);
                            }
                            return original.getChildren((Object)variable, from, to);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return original.getChildren((Object)variable, from, to);
                        }
                    }
                    return ch;
                }
                String code = f.getChildrenFormatCode();
                if (code != null && code.length() > 0) {
                    try {
                        Method evaluateMethod = ov.getClass().getMethod("evaluate", String.class);
                        evaluateMethod.setAccessible(true);
                        Variable ret = (Variable)evaluateMethod.invoke((Object)ov, code);
                        if (ret == null) {
                            return new Object[0];
                        }
                        return this.getChildren(original, ret, from, to, formatters);
                    }
                    catch (InvocationTargetException itex) {
                        Throwable t = itex.getTargetException();
                        if (t instanceof InvalidExpressionException) {
                            return original.getChildren((Object)variable, from, to);
                        }
                        Exceptions.printStackTrace((Throwable)t);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else if (formattersInLoopRef[0] != null) {
                this.printFormattersInLoopDetected(formattersInLoopRef[0]);
            }
        }
        return original.getChildren((Object)variable, from, to);
    }

    public int getChildrenCount(TreeModel original, Variable variable) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpandTest(final ObjectVariable ov, final JPDAClassType ct, final TreeModel original) {
        Set<ObjectVariable> set = this.childrenExpandTestProcessing;
        synchronized (set) {
            this.childrenExpandTestProcessing.add(ov);
        }
        this.expandTestProcessor.post(new Runnable(){
            final /* synthetic */ VariablesFormatterFilter this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block17: {
                    boolean isLeaf = false;
                    try {
                        VariablesFormatter f = Formatters.getFormatterForType((JPDAClassType)ct, (VariablesFormatter[])this.this$0.getFormattersWithExpandTestCode());
                        if (f == null) break block17;
                        String expandTestCode = f.getChildrenExpandTestCode();
                        if ("false".equals(expandTestCode)) {
                            this.this$0.childrenExpandTest.put(ov, true);
                            isLeaf = true;
                        }
                        if ("true".equals(expandTestCode)) {
                            this.this$0.childrenExpandTest.put(ov, false);
                        }
                        try {
                            Method evaluateMethod = ov.getClass().getMethod("evaluate", String.class);
                            evaluateMethod.setAccessible(true);
                            Variable ret = (Variable)evaluateMethod.invoke((Object)ov, expandTestCode);
                            if (ret != null) {
                                isLeaf = !"true".equals(ret.getValue());
                                this.this$0.childrenExpandTest.put(ov, isLeaf);
                            }
                        }
                        catch (InvocationTargetException itex) {
                            Throwable t = itex.getTargetException();
                            if (t instanceof InvalidExpressionException) {
                                break block17;
                            }
                            Exceptions.printStackTrace((Throwable)t);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    finally {
                        Set set = this.this$0.childrenExpandTestProcessing;
                        synchronized (set) {
                            this.this$0.childrenExpandTestProcessing.remove(ov);
                            this.this$0.childrenExpandTestProcessing.notifyAll();
                        }
                        if (isLeaf) {
                            this.this$0.fireLeafChange(original, (Variable)ov);
                        }
                    }
                }
            }
        });
    }

    private void fireLeafChange(TreeModel original, Variable variable) {
        if (this.vtmf == null) {
            List tmfs = this.lookupProvider.lookup("LocalsView", TreeModelFilter.class);
            for (TreeModelFilter tmf : tmfs) {
                if (!(tmf instanceof VariablesTreeModelFilter)) continue;
                this.vtmf = (VariablesTreeModelFilter)tmf;
                break;
            }
        }
        if (this.vtmf != null) {
            this.vtmf.fireChildrenChange(variable);
        }
    }

    public boolean isLeaf(TreeModel original, Variable variable) throws UnknownTypeException {
        if (variable instanceof ObjectVariable) {
            ObjectVariable ov = (ObjectVariable)variable;
            JPDAClassType ct = ov.getClassType();
            if (ct == null) {
                return original.isLeaf((Object)variable);
            }
            Boolean leaf = this.childrenExpandTest.get(ov);
            if (leaf != null) {
                return leaf;
            }
            this.doExpandTest(ov, ct, original);
            return false;
        }
        String type = variable.getType();
        if (VariablesFormatterFilter.isLeafType(type)) {
            return true;
        }
        return original.isLeaf((Object)variable);
    }

    public Object getValueAt(TableModel original, Variable variable, String columnID) throws UnknownTypeException {
        if (!(variable instanceof ObjectVariable)) {
            return original.getValueAt((Object)variable, columnID);
        }
        try {
            Object val = this.getValueAt(original, variable, columnID, new FormattersLoopControl());
            VariablesTableModel.setErrorValueMsg(variable, null);
            VariablesTableModel.setErrorToStringMsg(variable, null);
            return val;
        }
        catch (InvalidExpressionException iex) {
            String errorMsg = VariablesTableModel.getMessage(iex);
            VariablesTableModel.setErrorValueMsg(variable, errorMsg);
            VariablesTableModel.setErrorToStringMsg(variable, errorMsg);
            return errorMsg;
        }
    }

    private Object getValueAt(TableModel original, Variable variable, String columnID, FormattersLoopControl formatters) throws UnknownTypeException, InvalidExpressionException {
        if (!(variable instanceof ObjectVariable)) {
            return original.getValueAt((Object)variable, columnID);
        }
        String type = variable.getType();
        ObjectVariable ov = (ObjectVariable)variable;
        JPDAClassType ct = ov.getClassType();
        if (ct == null) {
            return original.getValueAt((Object)variable, columnID);
        }
        VariablesFormatter f = Formatters.getFormatterForType((JPDAClassType)ct, (VariablesFormatter[])formatters.getFormatters());
        String[] formattersInLoopRef = new String[]{null};
        if (f != null && formatters.canUse(f, ct.getName(), formattersInLoopRef) && (columnID == "LocalsValue" || columnID == "WatchValue" || columnID == "LocalsToString" || columnID == "WatchToString")) {
            String code = f.getValueFormatCode();
            if (code != null && code.length() > 0) {
                try {
                    Method evaluateMethod = ov.getClass().getMethod("evaluate", String.class);
                    evaluateMethod.setAccessible(true);
                    Variable ret = (Variable)evaluateMethod.invoke((Object)ov, code);
                    if (ret == null) {
                        return null;
                    }
                    return this.getValueAt(original, ret, columnID, formatters);
                }
                catch (InvocationTargetException itex) {
                    Throwable t = itex.getTargetException();
                    if (t instanceof InvalidExpressionException) {
                        throw (InvalidExpressionException)t;
                    }
                    Exceptions.printStackTrace((Throwable)t);
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (UnknownTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (formattersInLoopRef[0] != null) {
            this.printFormattersInLoopDetected(formattersInLoopRef[0]);
        }
        if (VariablesFormatterFilter.isToStringValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue")) {
            try {
                return "\"" + ov.getToStringValue() + "\"";
            }
            catch (InvalidExpressionException ex) {
                Logger.getLogger(VariablesFormatterFilter.class.getName()).fine("getToStringValue() " + ex.getLocalizedMessage());
                if (ex.getTargetException() != null && ex.getTargetException() instanceof UnsupportedOperationException) {
                    return original.getValueAt((Object)variable, columnID);
                }
                return ex.getLocalizedMessage();
            }
        }
        return original.getValueAt((Object)variable, columnID);
    }

    public void setValueAt(TableModel original, Variable variable, String columnID, Object value) throws UnknownTypeException {
        String expression;
        String type = variable.getType();
        if (VariablesFormatterFilter.isToStringValueType(type) && (columnID == "LocalsValue" || columnID == "WatchValue") && (expression = (String)value).startsWith("\"") && expression.endsWith("\"") && expression.length() > 1) {
            expression = "new " + type + "(\"" + VariablesFormatterFilter.convertToStringInitializer(expression.substring(1, expression.length() - 1)) + "\")";
            original.setValueAt((Object)variable, columnID, (Object)expression);
            return;
        }
        original.setValueAt((Object)variable, columnID, value);
    }

    private static String convertToStringInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        block9: for (int i = 0; i < k; ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static boolean isLeafType(String type) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(type);
    }

    private static boolean isToStringValueType(String type) {
        if (toStringValueType == null) {
            toStringValueType = new HashSet();
            toStringValueType.add("java.lang.StringBuffer");
            toStringValueType.add("java.lang.StringBuilder");
        }
        return toStringValueType.contains(type);
    }

    private void printFormattersInLoopDetected(String formattersInLoop) {
        JPDADebuggerImpl debugger = (JPDADebuggerImpl)this.lookupProvider.lookupFirst(null, JPDADebugger.class);
        if (debugger != null) {
            if (!this.formattersLoopWarned) {
                this.formattersLoopWarned = true;
                debugger.getConsoleIO().println(NbBundle.getMessage(VariablesFormatterFilter.class, (String)"MSG_LoopInTypeFormattingIntroErrorMessage"), null, true);
            }
            debugger.getConsoleIO().println(NbBundle.getMessage(VariablesFormatterFilter.class, (String)"MSG_LoopInTypeFormatting", (Object)formattersInLoop), null, false);
        }
    }

    static /* synthetic */ VariablesFormatter[] access$102(VariablesFormatterFilter x0, VariablesFormatter[] x1) {
        x0.formattersWithExpandTestCode = x1;
        return x1;
    }
}

