from pydantic import BaseModel
from sqlalchemy import Column, Integer, Double, ForeignKey
from sqlalchemy.orm import relationship

from ..base import Base


class ThreadConcurrency(Base):
    __tablename__ = 'thread_concurrency'
    id = Column(Integer, primary_key=True, index=True)
    thread_index = Column(Integer)
    concurrency_time_ms = Column(Double)
    concurrency_pct = Column(Double)
    report_id = Column(Integer, ForeignKey('report.id'))
    report = relationship('Report', back_populates='thread_concurrency')


class ThreadConcurrencyInDB(BaseModel):
    id: int
    thread_index: int
    concurrency_time_ms: float
    concurrency_pct: float

    class Config:
        from_attributes = True


class ThreadConcurrencyCreate(BaseModel):
    thread_index: int
    concurrency_time_ms: float
    concurrency_pct: float
