
/*
 * -----------------------------------------------------------------------------
 * This source file is part of OGRE
 * (Object-oriented Graphics Rendering Engine)
 * For the latest info, see http://www.ogre3d.org/
 *
 * Copyright (c) 2000-2014 Torus Knot Software Ltd
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * -----------------------------------------------------------------------------
 */

#ifndef _LodCollapseCostQuadric_H__
#define _LodCollapseCostQuadric_H__

#include "OgreLodPrerequisites.h"
#include "OgreLodCollapseCost.h"
#include "OgreLodData.h"
#include "OgreMatrix4.h"
#include "OgreHeaderPrefix.h"

namespace Ogre
{

class _OgreLodExport LodCollapseCostQuadric :
    public LodCollapseCost
{
public:
    void initCollapseCosts(LodData* data) override;
    void updateVertexCollapseCost(LodData* data, LodData::Vertex* vertex) override;
    Real computeEdgeCollapseCost(LodData* data, LodData::Vertex* src, LodData::Edge* dstEdge) override;
protected:

    struct TriangleQuadricPlane {
        Matrix4 quadric;
    };
    std::vector<Matrix4> mTrianglePlaneQuadricList;
    std::vector<Matrix4> mVertexQuadricList;
    void computeTrianglePlaneQuadric(LodData* data, size_t triangleID);
    void computeVertexQuadric(LodData* data, size_t vertexID);
};

}

#include "OgreHeaderSuffix.h"

#endif


