/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.profile.ProfileResult;

@PublicApi(since="1.0.0")
public final class AggregationProfileShardResult
implements Writeable,
ToXContentFragment {
    public static final String AGGREGATIONS = "aggregations";
    private final List<ProfileResult> aggProfileResults;

    public AggregationProfileShardResult(List<ProfileResult> aggProfileResults) {
        this.aggProfileResults = aggProfileResults;
    }

    public AggregationProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.aggProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.aggProfileResults.add(new ProfileResult(in));
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggProfileResults.size());
        for (ProfileResult p : this.aggProfileResults) {
            p.writeTo(out);
        }
    }

    public List<ProfileResult> getProfileResults() {
        return Collections.unmodifiableList(this.aggProfileResults);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(AGGREGATIONS);
        for (ProfileResult p : this.aggProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static AggregationProfileShardResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
        ArrayList<ProfileResult> aggProfileResults = new ArrayList<ProfileResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            aggProfileResults.add(ProfileResult.fromXContent(parser));
        }
        return new AggregationProfileShardResult(aggProfileResults);
    }
}

