-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Data soruces used (took intersection of first two links with all the rest):
-- http://www.top-names.info/names.php?S=M&P=NED
-- http://www.top-names.info/names.php?S=F&P=NED
-- https://en.wikipedia.org/wiki/List_of_Dutch_family_names
-- http://www.studentsoftheworld.info/penpals/stats.php?Pays=NED
-- https://www.babynamewizard.com/name-list/dutch-girls-names-most-popular-names-for-girls-in-the-netherlands
-- https://www.momjunction.com/articles/dutch-baby-names-for-boys-and-girls_00397951/
-- https://suggesname.com/dutch-boy-names/

-- interesting:
-- https://forebears.io/netherlands/forenames
-- http://www.meertens.knaw.nl/nfb/index.php?taal=eng
-- https://en.wikipedia.org/wiki/Category:Dutch_masculine_given_names

local CultureName = require './common'

local male = {
	"Jesse",
	"Julian",
	"Dirk",
	"Berend",
	"Dennis",
	"Hans",
	"Willem",
	"Jan",
	"Max",
	"Sem",
	"Daan",
	"Stefan",
	"Rick",
	"Timo",
	"Bart",
	"Bram",
	"Jeroen",
	"Nick",
	"Vincent",
	"Gerrit",
	"Abel",
	"Peter",
	"Cas",
	"Sven",
	"Luuk",
	"David",
	"Lars",
	"Remco",
	"Tim",
	"Thomas",
	"Sam",
	"Liam",
	"Patrick",
	"Johan",
	"Stijn",
	"Kees",
	"Jasper",
	"Jordy",
	"Robert",
	"Noah",
	"Floris",
	"Niels",
	"Milan",
	"Ruben",
	"Levi",
	"Alexander",
	"Bas",
	"Lucas",
	"Coen",
	"Erik",
	"Henk",
}

local female = {
	"Sophie",
	"Jade",
	"Nikki",
	"Lois",
	"Emily",
	"Fenna",
	"Femke",
	"Ilse",
	"Amber",
	"Eva",
	"Lotte",
	"Lauren",
	"Merel",
	"Evi",
	"Lynn",
	"Sara",
	"Rosalie",
	"Amy",
	"Lina",
	"Lena",
	"Roos",
	"Marit",
	"Jasmijn",
	"Tess",
	"Maud",
	"Sarah",
	"Lisa",
	"Julia",
	"Anne",
	"Sanne",
	"Sofie",
	"Noor",
	"Bente",
	"Veerle",
	"Anna",
	"Senna",
	"Iris",
	"Sophia",
	"Lola",
	"Linde",
	"Emma",
	"Eline",
	"Isa",
	"Elise",
	"Sofia",
	"Esmee",
	"Charlotte",
	"Hannah",
	"Mila",
	"Lara",
	"Tessa",
	"Naomi",
	"Noa",
	"Doortje",
	"Ella",
	"Gwen",
	"Nina",
	"Nova",
}

local surname = {
	"de Jong",
	"Jansen",
	"de Vries",
	"Bakker",
	"Janssen",
	"van Dijk",
	"Visser",
	"Smit",
	"de Boer",
	"de Groot",
	"Mulder",
	"Meijer",
	"Bos",
	"Vos",
	"Peters",
	"van der Berg",
	"Hendriks",
	"Dekker",
	"van Leeuwen",
	"Brouwer",
	"van den Berg",
	"Dijkstra",
	"de Wit",
	"Smits",
	"Kok",
	"Vermeulen",
	"de Graaf",
	"van der Meer",
	"Jacobs",
	"de Haan",
	"van der Linden",
	"Schouten",
	"van der Veen",
	"de Bruin",
	"van Vliet",
	"Willems",
	"Hoekstra",
	"van Beek",
	"Koster",
	"Maas",
	"van Dam",
	"Prins",
	"Verhoeven",
	"Huisman",
	"Blom",
	"Peeters",
	"Kuipers",
	"de Bruijn",
	"van der Heijden",
	"de Jonge",
	"Kramer",
	"Post",
	"van der Wal",
	"Kuiper",
	"van Veen",
	"Boer",
	"Groot",
	"Scholten",
	"Klein",
	"van Wijk",
	"Martens",
	"Veenstra",
	"Groen",
	"Vink",
	"Postma",
	"Bosch",
	"de Ruiter",
	"Koning",
	"Smeets",
	"de Lange",
	"Timmermans",
	"Jonker",
	"de Vos",
	"de Koning",
	"Hermans",
	"Gerritsen",
	"Schipper",
	"Van Loon",
	"Willemsen",
	"Evers",
	"Driessen",
	"Sanders",
	"Molenaar",
	"van Dongen",
	"Mol",
	"Bosman",
	"van Doorn",
	"van der Laan",
	"Verbeek",
	"de Leeuw",
	"van der Velden",
	"van der Meulen",
	"van der Horst",
	"Roos",
	"van der Heuvel",
	"Stam",
	"Hofman",
	"Muller",
	"Kroon",
	"Wolters",
}

local Dutch = CultureName.New({
	male = male,
	female = female,
	surname = surname,
	name = "Dutch",
	code = "nl",
})

return Dutch
