/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;

public final class FilterEncoder {
    private FilterEncoder() {
    }

    public static String format(String filterTemplate, String ... values) {
        MessageFormat mf;
        Format[] formats;
        if (values == null) {
            values = Strings.EMPTY_STRING_ARRAY;
        }
        if ((formats = (mf = new MessageFormat(filterTemplate, Locale.ROOT)).getFormatsByArgumentIndex()).length != values.length) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13300_BAD_PLACE_HOLDERS_NUMBER, filterTemplate, formats.length, values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = FilterEncoder.encodeFilterValue(values[i]);
        }
        return mf.format(values);
    }

    public static String encodeFilterValue(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        boolean escaped = false;
        boolean hexPair = false;
        char hex = '\u0000';
        block8: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '*': {
                    if (escaped) {
                        sb.append("\\5C");
                        if (hexPair) {
                            sb.append(hex);
                            hexPair = false;
                        }
                        escaped = false;
                    }
                    sb.append("\\2A");
                    continue block8;
                }
                case '(': {
                    if (escaped) {
                        sb.append("\\5C");
                        if (hexPair) {
                            sb.append(hex);
                            hexPair = false;
                        }
                        escaped = false;
                    }
                    sb.append("\\28");
                    continue block8;
                }
                case ')': {
                    if (escaped) {
                        sb.append("\\5C");
                        if (hexPair) {
                            sb.append(hex);
                            hexPair = false;
                        }
                        escaped = false;
                    }
                    sb.append("\\29");
                    continue block8;
                }
                case '\u0000': {
                    if (escaped) {
                        sb.append("\\5C");
                        if (hexPair) {
                            sb.append(hex);
                            hexPair = false;
                        }
                        escaped = false;
                    }
                    sb.append("\\00");
                    continue block8;
                }
                case '\\': {
                    if (escaped) {
                        sb.append("\\5C");
                        escaped = false;
                        continue block8;
                    }
                    escaped = true;
                    hexPair = false;
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (escaped) {
                        if (hexPair) {
                            sb.append('\\').append(hex).append(ch);
                            escaped = false;
                            hexPair = false;
                            continue block8;
                        }
                        hexPair = true;
                        hex = ch;
                        continue block8;
                    }
                    sb.append(ch);
                    continue block8;
                }
                default: {
                    if (escaped) {
                        sb.append("\\5C");
                        if (hexPair) {
                            sb.append(hex);
                            hexPair = false;
                        }
                        escaped = false;
                    }
                    sb.append(ch);
                }
            }
        }
        if (escaped) {
            sb.append("\\5C");
        }
        return sb.toString();
    }
}

