/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.log.LogStatusListener;
import org.protege.editor.core.ui.util.Icons;

public class LogStatusLabel
extends JLabel
implements LogStatusListener {
    private static final long serialVersionUID = -6000196744393026164L;
    private static final Icon LOG_ERROR_ICON_ = Icons.getIcon("error.png");
    private static final Icon LOG_WARNING_ICON_ = Icons.getIcon("warning.png");
    private static final Icon LOG_ICON_ = Icons.getIcon("log.png");
    private static final String LOG_TOOLTIP_ = "Click to open the log";
    private static final String LOG_EVENT_TOOLTIP_ = "<html><body>...<br>%s<br>Click to open the log</body></html>";
    private static int LOG_MESSAGE_LIMIT = 64;
    private Level thresholdLevel;
    private ILoggingEvent lastImportantEvent;

    public LogStatusLabel() {
        this.statusCleared();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ProtegeApplication.showLogView();
            }
        });
        this.setToolTipText(LOG_TOOLTIP_);
    }

    @Override
    public synchronized void eventLogged(ILoggingEvent event) {
        Level logLevel = event.getLevel();
        if (logLevel.isGreaterOrEqual(this.thresholdLevel)) {
            this.thresholdLevel = logLevel;
            this.lastImportantEvent = event;
            if (logLevel.isGreaterOrEqual(Level.ERROR)) {
                this.setIcon(LOG_ERROR_ICON_);
            } else {
                this.setIcon(LOG_WARNING_ICON_);
            }
        }
    }

    @Override
    public synchronized void statusCleared() {
        this.lastImportantEvent = null;
        this.thresholdLevel = Level.WARN;
        this.setIcon(LOG_ICON_);
    }

    @Override
    public synchronized String getToolTipText(MouseEvent event) {
        if (this.lastImportantEvent != null) {
            return String.format(LOG_EVENT_TOOLTIP_, LogStatusLabel.truncate(this.lastImportantEvent.toString()));
        }
        return super.getToolTipText(event);
    }

    static String truncate(String message) {
        if (((String)message).length() > LOG_MESSAGE_LIMIT) {
            message = ((String)message).substring(0, LOG_MESSAGE_LIMIT - 2) + "...";
        }
        return message;
    }
}

