/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDPatternResources;
import org.apache.pdfbox.util.Matrix;

public class PDTilingPatternResources
extends PDPatternResources {
    public PDTilingPatternResources() {
        this.getCOSDictionary().setInt(COSName.PATTERN_TYPE, 1);
    }

    public PDTilingPatternResources(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public void setLength(int length) {
        this.getCOSDictionary().setInt(COSName.LENGTH, length);
    }

    @Override
    public int getLength() {
        return this.getCOSDictionary().getInt(COSName.LENGTH, 0);
    }

    @Override
    public void setPaintType(int paintType) {
        this.getCOSDictionary().setInt(COSName.PAINT_TYPE, paintType);
    }

    public int getPaintType() {
        return this.getCOSDictionary().getInt(COSName.PAINT_TYPE, 0);
    }

    public void setTilingType(int tilingType) {
        this.getCOSDictionary().setInt(COSName.TILING_TYPE, tilingType);
    }

    public int getTilingType() {
        return this.getCOSDictionary().getInt(COSName.TILING_TYPE, 0);
    }

    public void setXStep(int xStep) {
        this.getCOSDictionary().setInt(COSName.X_STEP, xStep);
    }

    public int getXStep() {
        return this.getCOSDictionary().getInt(COSName.X_STEP, 0);
    }

    public void setYStep(int yStep) {
        this.getCOSDictionary().setInt(COSName.Y_STEP, yStep);
    }

    public int getYStep() {
        return this.getCOSDictionary().getInt(COSName.Y_STEP, 0);
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        if (resources != null) {
            this.getCOSDictionary().setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.getCOSDictionary().removeItem(COSName.RESOURCES);
        }
    }

    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSDictionary().removeItem(COSName.BBOX);
        } else {
            this.getCOSDictionary().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }

    public Matrix getMatrix() {
        Matrix retval = null;
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((COSNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((COSNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((COSNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((COSNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((COSNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((COSNumber)array.get(5)).floatValue());
        }
        return retval;
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSDictionary().setItem(COSName.MATRIX, (COSBase)matrix);
    }

    @Override
    public Paint getPaint(int pageHeight) throws IOException {
        return null;
    }
}

