/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension;

import org.zaproxy.zap.control.AddOn;

public interface AddOnInstallationStatusListener {
    default public void update(StatusUpdate statusUpdate) {
        switch (statusUpdate.getStatus()) {
            case INSTALLED: {
                this.addOnInstalled(statusUpdate.getAddOn());
                break;
            }
            case SOFT_UNINSTALLED: {
                this.addOnSoftUninstalled(statusUpdate.getAddOn(), statusUpdate.isSuccessful());
                break;
            }
            case UNINSTALLED: {
                this.addOnUninstalled(statusUpdate.getAddOn(), statusUpdate.isSuccessful());
                break;
            }
        }
    }

    @Deprecated(since="2.15.0", forRemoval=true)
    default public void addOnInstalled(AddOn addOn) {
    }

    @Deprecated(since="2.15.0", forRemoval=true)
    default public void addOnSoftUninstalled(AddOn addOn, boolean successfully) {
    }

    @Deprecated(since="2.15.0", forRemoval=true)
    default public void addOnUninstalled(AddOn addOn, boolean successfully) {
    }

    public static interface StatusUpdate {
        public boolean isSuccessful();

        public Status getStatus();

        public AddOn getAddOn();

        public static enum Status {
            INSTALL,
            INSTALLED,
            SOFT_UNINSTALL,
            SOFT_UNINSTALLED,
            UNINSTALL,
            UNINSTALLED;

        }
    }
}

