# data.py
# This file is part of qarte 5
#    
# Author: Vincent Vande Vyvre <vincent.vandevyvre@oqapy.eu>
# Copyright: 2011-2025 Vincent Vande Vyvre
# Licence: GPL3
# Home page: https://launchpad.net/qarte
#
# Constants list, XXX don't forget to update VERSION if needed.


VERSION = (5, 17, 0)

VERSION_STR = '.'.join(str(i) for i in VERSION)

ARTE_TV = "https://www.arte.tv/fr/guide/DAY/"

USER_AGENT = "Qarte/%s" % VERSION_STR

CONFIG_DEFAULT = {'version': VERSION,
                'lang': 'fr',
                'load_pages': [True, False],
                'video_player': True,
                'videos_folder': None, 
                'music_folder': None,
                'add_date': False,
                'add_subtitle': False,
                'merge_files': True,
                'proxy': None,
                'pitch_plus': True,
                'pitch_plus_unique': 1, 
                'pitch_plus_format': 'txt',
                'pitch_live': True,
                'pitch_live_unique': 1, 
                'pitch_live_format': 'html',
                'copythumb_plus': False,
                'copythumb_live': False,
                'update': True, 
                'thumb1': 160, 
                'thumb2': 80, 
                #'notify': True,  
                'size': (900, 700),
                'tv_quality': 720,
                'live_quality': 'HTTP_EQ_1',
                #'show_rpm': False,
                'cur_cat': 'Jazz & Blues', 
                'mini': 220, 
                'maxi': 325, 
                #'news': [False, True, True, False, True],
                'crontab_cmd': 'export DISPLAY=:0 & LC_CTYPE="<lang>" Lang="<lang>" qarte -a <ID> >> "<log>" 2>&1',
                'filter_keys': []}





