/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Event;
import com.fluendo.jst.Sink;
import com.fluendo.jst.SystemClock;
import com.fluendo.jst.WaitStatus;
import com.fluendo.utils.Debug;

public abstract class AudioSink
extends Sink
implements ClockProvider {
    protected RingBuffer ringBuffer = null;
    private AudioClock audioClock = new AudioClock();

    public Clock provideClock() {
        return this.audioClock;
    }

    public boolean test() {
        return true;
    }

    protected WaitStatus doSync(long l) {
        return WaitStatus.newOK();
    }

    protected boolean doEvent(Event event) {
        switch (event.getType()) {
            case 1: {
                this.ringBuffer.setFlushing(true);
                break;
            }
            case 2: {
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.drain();
            }
        }
        return true;
    }

    protected int render(Buffer buffer) {
        long l;
        if (buffer.isFlagSet(1)) {
            this.ringBuffer.nextSample = -1L;
        }
        if ((l = buffer.timestamp - this.segStart) < 0L) {
            return 0;
        }
        long l2 = (l += this.baseTime) * (long)this.ringBuffer.rate / 1000000L;
        this.ringBuffer.commit(buffer.data, l2, buffer.offset, buffer.length);
        return 0;
    }

    protected boolean setCapsFunc(Caps caps) {
        this.ringBuffer.release();
        boolean bl = this.ringBuffer.acquire(caps);
        return bl;
    }

    protected int changeState(int n) {
        switch (n) {
            case 18: {
                this.ringBuffer = this.createRingBuffer();
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 35: {
                this.ringBuffer.setAutoStart(true);
                break;
            }
            case 50: {
                this.reset();
                this.ringBuffer.setAutoStart(false);
                this.ringBuffer.pause();
                break;
            }
            case 33: {
                this.ringBuffer.setFlushing(true);
            }
        }
        int n2 = super.changeState(n);
        switch (n) {
            case 33: {
                this.ringBuffer.release();
            }
        }
        return n2;
    }

    protected void drain() {
        if (this.ringBuffer.rate <= 0) {
            return;
        }
        if (!this.ringBuffer.isAcquired()) {
            return;
        }
        if (this.ringBuffer.getState() != 3) {
            this.ringBuffer.play();
        }
        if (this.ringBuffer.nextSample != -1L) {
            long l = this.ringBuffer.nextSample * 1000000L / (long)this.ringBuffer.rate;
            Clock.ClockID clockID = this.audioClock.newSingleShotID(l);
            Debug.log(4, this + " waiting until t=" + (double)l / 1000000.0 + "s for playback to finish");
            clockID.waitID();
            this.ringBuffer.nextSample = -1L;
        }
    }

    protected abstract RingBuffer createRingBuffer();

    protected abstract boolean open(RingBuffer var1);

    protected abstract boolean close(RingBuffer var1);

    protected abstract int write(byte[] var1, int var2, int var3);

    protected abstract long delay();

    protected abstract void reset();

    private class AudioClock
    extends SystemClock {
        private long lastTime = -1L;
        private long diff = -1L;
        private boolean started = false;

        private AudioClock() {
        }

        public void setStarted(boolean bl) {
            this.started = bl;
            if (this.started) {
                this.diff = -1L;
                this.lastTime = -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getInternalTime() {
            long l;
            RingBuffer ringBuffer = AudioSink.this.ringBuffer;
            synchronized (ringBuffer) {
                block8: {
                    if (AudioSink.this.ringBuffer != null && AudioSink.this.ringBuffer.rate != 0) break block8;
                    return 0L;
                }
                long l2 = AudioSink.this.ringBuffer.samplesPlayed();
                long l3 = l2 * 1000000L / (long)AudioSink.this.ringBuffer.rate;
                if (this.started) {
                    long l4 = System.currentTimeMillis() * 1000L;
                    if (this.diff == -1L) {
                        this.diff = l4;
                    }
                    if (l3 != this.lastTime) {
                        this.lastTime = l3;
                        this.diff = l4 - l3;
                    }
                    l = l4 - this.diff;
                } else {
                    l = l3;
                }
            }
            return l;
        }
    }

    protected class RingBuffer
    implements Runnable {
        protected byte[] buffer;
        private int state;
        private Thread thread;
        private long nextSample;
        private boolean flushing;
        private boolean autoStart;
        private boolean opened;
        private static final int STOP = 0;
        private static final int PAUSE = 1;
        private static final int PLAY = 2;
        public int bps;
        public int sps;
        public byte[] emptySeg;
        public long playSeg;
        public int segTotal;
        public int segSize;
        public int rate;
        public int channels;

        protected RingBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            while (bl) {
                RingBuffer ringBuffer = this;
                synchronized (ringBuffer) {
                    if (this.state != 2) {
                        while (this.state == 1) {
                            try {
                                this.notifyAll();
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.state == 0) {
                            bl = false;
                            break;
                        }
                    }
                }
                int n = (int)(this.playSeg % (long)this.segTotal);
                int n2 = n * this.segSize;
                int n3 = this.segSize;
                while (n3 > 0) {
                    int n4 = AudioSink.this.write(this.buffer, n2, this.segSize);
                    if (n4 == -1) break;
                    n3 -= n4;
                }
                this.clear(n);
                RingBuffer ringBuffer2 = this;
                synchronized (ringBuffer2) {
                    ++this.playSeg;
                    this.notifyAll();
                }
            }
        }

        public synchronized void setFlushing(boolean bl) {
            this.flushing = bl;
            this.clearAll();
            if (bl) {
                this.pause();
            }
        }

        protected void startWriteThread() {
            this.thread = new Thread((Runnable)this, "cortado-audiosink-ringbuffer");
            this.thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }

        public synchronized boolean acquire(Caps caps) {
            if (this.thread != null) {
                return false;
            }
            if (this.opened) {
                return false;
            }
            String string = caps.getMime();
            if (!string.equals("audio/raw")) {
                return false;
            }
            this.rate = caps.getFieldInt("rate", 44100);
            this.channels = caps.getFieldInt("channels", 1);
            this.bps = 2 * this.channels;
            boolean bl = AudioSink.this.open(this);
            if (!bl) {
                return bl;
            }
            this.opened = true;
            Debug.log(3, "audio: segSize: " + this.segSize);
            Debug.log(3, "audio: segTotal: " + this.segTotal);
            ++this.segTotal;
            this.buffer = new byte[this.segSize * this.segTotal];
            this.sps = this.segSize / this.bps;
            this.state = 1;
            this.nextSample = 0L;
            this.playSeg = 0L;
            this.startWriteThread();
            return bl;
        }

        public synchronized boolean isAcquired() {
            return this.opened;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean release() {
            this.stop();
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                block4: {
                    if (!this.opened || AudioSink.this.close(this)) break block4;
                    return false;
                }
                this.opened = false;
            }
            return true;
        }

        private synchronized boolean waitSegment() {
            block8: {
                block7: {
                    if (this.flushing) {
                        return false;
                    }
                    if (this.state != 2 && this.autoStart) {
                        this.play();
                    }
                    try {
                        if (this.state == 2) break block7;
                        return false;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.wait();
                if (!this.flushing) break block8;
                return false;
            }
            if (this.state != 2) {
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int commit(byte[] byArray, long l, int n, int n2) {
            if (l == -1L) {
                l = this.nextSample;
            }
            if (l < 0L) {
                return n2;
            }
            if (this.nextSample != -1L) {
                if (Math.abs(l - this.nextSample) < (long)(this.rate / 10)) {
                    l = this.nextSample;
                } else {
                    System.out.println("discont: found " + l + " expected " + this.nextSample);
                }
            }
            int n3 = 0;
            this.nextSample = l + (long)(n2 / this.bps);
            while (n2 > 0) {
                int n4;
                long l2;
                long l3;
                int n5;
                block12: {
                    n5 = 0;
                    l3 = -1L;
                    l2 = l / (long)this.sps;
                    n4 = (int)(l % (long)this.sps * (long)this.bps);
                    do {
                        RingBuffer ringBuffer = this;
                        synchronized (ringBuffer) {
                            l3 = l2 - this.playSeg;
                        }
                        if (l3 < 0L) {
                            n5 = Math.min(this.segSize, n2);
                            break block12;
                        }
                        if (l3 < (long)this.segTotal) break block12;
                    } while (this.waitSegment());
                    return -1;
                }
                if (l3 >= 0L) {
                    int n6 = (int)(l2 % (long)this.segTotal);
                    n5 = Math.min(this.segSize - n4, n2);
                    System.arraycopy(byArray, n3, this.buffer, n6 * this.segSize + n4, n5);
                }
                n2 -= n5;
                n3 += n5;
                l += (long)(n5 / this.bps);
            }
            return n2;
        }

        public long samplesPlayed() {
            long l = AudioSink.this.delay();
            long l2 = Math.max(0L, this.playSeg - 1L);
            long l3 = l2 * (long)this.sps;
            l3 = l3 >= l ? (l3 -= l) : 0L;
            return l3;
        }

        public synchronized void clear(long l) {
            int n = (int)(l % (long)this.segTotal) * this.segSize;
            System.arraycopy(this.emptySeg, 0, this.buffer, n, this.segSize);
        }

        public synchronized void clearAll() {
            int n = 0;
            while (n < this.segTotal) {
                this.clear(n);
                ++n;
            }
        }

        public synchronized void setSample(long l) {
            if (l == -1L) {
                l = 0L;
            }
            this.playSeg = l / (long)this.sps;
            this.nextSample = l;
            this.clearAll();
        }

        public synchronized void setAutoStart(boolean bl) {
            this.autoStart = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean play() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                block4: {
                    if (!this.flushing) break block4;
                    return false;
                }
                this.state = 2;
                AudioSink.this.audioClock.setStarted(true);
                this.notifyAll();
            }
            Debug.log(4, this + " playing");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pause() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                Debug.log(4, this + " pausing");
                this.state = 1;
                AudioSink.this.audioClock.setStarted(false);
                this.notifyAll();
                if (this.thread != null) {
                    try {
                        Debug.log(4, this + " waiting for pause");
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Debug.log(4, this + " paused");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stop() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                Debug.log(4, this + " stopping");
                this.state = 0;
                AudioSink.this.audioClock.setStarted(false);
                this.notifyAll();
            }
            if (this.thread != null) {
                try {
                    Debug.log(4, this + " joining thread");
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException interruptedException) {}
            }
            Debug.log(4, this + " stopped");
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }
    }
}

