package cmd

import (
	"fmt"
	"os"

	"github.com/charmbracelet/lipgloss"
	"github.com/spf13/cobra"
)

const version = "1.0.0"

var (
	// Styles for consistent UI
	titleStyle = lipgloss.NewStyle().
		Bold(true).
		Foreground(lipgloss.Color("#00D7FF")).
		MarginLeft(1)

	errorStyle = lipgloss.NewStyle().
		Bold(true).
		Foreground(lipgloss.Color("#FF0000")).
		MarginLeft(1)

	successStyle = lipgloss.NewStyle().
		Bold(true).
		Foreground(lipgloss.Color("#00FF00")).
		MarginLeft(1)

	infoStyle = lipgloss.NewStyle().
		Foreground(lipgloss.Color("#FFFF00")).
		MarginLeft(1)
)

var rootCmd = &cobra.Command{
	Use:   "debpkg",
	Short: "A simple Debian package installer",
	Long: titleStyle.Render("debpkg") + `

A command-line tool for downloading and installing Debian packages from URLs.
This tool simplifies the process of installing .deb packages by handling
the download and installation in one command.`,
	Example: `  debpkg install https://example.com/package.deb
  debpkg --version
  debpkg --help`,
}

func init() {
	rootCmd.Version = version
	rootCmd.SetVersionTemplate(titleStyle.Render("debpkg") + " version " + version + "\n")
}

// Execute runs the root command
func Execute() error {
	return rootCmd.Execute()
}

// Helper functions for consistent output formatting
func PrintError(msg string) {
	fmt.Fprintln(os.Stderr, errorStyle.Render("✗ "+msg))
}

func PrintSuccess(msg string) {
	fmt.Println(successStyle.Render("✓ "+msg))
}

func PrintInfo(msg string) {
	fmt.Println(infoStyle.Render("ℹ "+msg))
}
