"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyGposTable = exports.rectifyGsubTable = void 0;
const Ot = require("@ot-builder/ot");
const cleanup_1 = require("./cleanup");
const lookup_removable_alg_1 = require("./lookup-removable-alg");
const rectify_1 = require("./rectify");
function fnApplyGsubLookup(lookup, alg) {
    return alg.process(lookup);
}
function fnGsubLookupRemovable(lookup) {
    return lookup_removable_alg_1.LookupRemovableAlg.process(lookup);
}
function fnApplyGposLookup(lookup, alg) {
    return alg.process(lookup);
}
function fnGposLookupRemovable(lookup) {
    return lookup_removable_alg_1.LookupRemovableAlg.process(lookup);
}
function rectifyGsubTable(recGlyphs, recAxes, recCoord, recPA, table) {
    const alg = new rectify_1.RectifyGsubGlyphCoordAlg(recGlyphs, recCoord, recPA);
    const lookupCorrespondence = (0, rectify_1.rectifyLookupList)(table.lookups, alg, fnApplyGsubLookup);
    const newTable = (0, cleanup_1.cleanupGsubGposData)(table, new Ot.Gsub.Table(), lookupCorrespondence, fnGsubLookupRemovable);
    if (newTable && newTable.featureVariations) {
        for (const fv of newTable.featureVariations)
            (0, cleanup_1.axesRectifyFeatureVariation)(recAxes, fv);
    }
    return newTable;
}
exports.rectifyGsubTable = rectifyGsubTable;
function rectifyGposTable(recGlyphs, recAxes, recCoord, recPA, table) {
    const alg = new rectify_1.RectifyGposGlyphCoordAlg(recGlyphs, recCoord, recPA);
    const lookupCorrespondence = (0, rectify_1.rectifyLookupList)(table.lookups, alg, fnApplyGposLookup);
    const newTable = (0, cleanup_1.cleanupGsubGposData)(table, new Ot.Gpos.Table(), lookupCorrespondence, fnGposLookupRemovable);
    if (newTable && newTable.featureVariations) {
        for (const fv of newTable.featureVariations)
            (0, cleanup_1.axesRectifyFeatureVariation)(recAxes, fv);
    }
    return newTable;
}
exports.rectifyGposTable = rectifyGposTable;
//# sourceMappingURL=index.js.map