"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultBezierContext = exports.SimplyCollectArcContext = void 0;
class SimplyCollectArcContext {
    constructor() {
        this.arcs = [];
    }
    beginShape() { }
    endShape() { }
    moveTo() { }
    arcTo(arc) {
        this.arcs.push(arc);
    }
}
exports.SimplyCollectArcContext = SimplyCollectArcContext;
class DefaultBezierContext {
    constructor() {
        this.strands = [];
        this.lastx = 0;
        this.lasty = 0;
    }
    beginShape() { }
    endShape() { }
    moveTo(x, y) {
        this.lastx = x;
        this.lasty = y;
    }
    lineTo(x, y) {
        const arc = {
            order: 1,
            start: { x: this.lastx, y: this.lasty },
            end: { x: x, y: y },
        };
        this.strands.push(arc);
        this.lastx = x;
        this.lasty = y;
    }
    curveTo(x1, y1, x, y) {
        const arc = {
            order: 2,
            start: { x: this.lastx, y: this.lasty },
            c1: { x: x1, y: y1 },
            end: { x: x, y: y },
        };
        this.strands.push(arc);
        this.lastx = x;
        this.lasty = y;
    }
    cubicTo(x1, y1, x2, y2, x, y) {
        const arc = {
            order: 3,
            start: { x: this.lastx, y: this.lasty },
            c1: { x: x1, y: y1 },
            c2: { x: x2, y: y2 },
            end: { x: x, y: y },
        };
        this.strands.push(arc);
        this.lastx = x;
        this.lasty = y;
    }
}
exports.DefaultBezierContext = DefaultBezierContext;
