"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transferGenericShapeAsBezier = exports.transferGenericShape = exports.transferBezArcShape = void 0;
const shape_to_bez3_1 = require("../bez-tool/shape-to-bez3");
const derivable_1 = require("../derivable");
const point_1 = require("../point/point");
function transferBezArcShape(shape, sink, tolerance = 1 / 16) {
    sink.beginShape();
    for (const contour of shape) {
        if (!contour.length)
            continue;
        let z0 = point_1.Point2.from(contour[0].eval(0));
        sink.moveTo(z0.x, z0.y);
        for (const arc of contour) {
            const a = point_1.Point2.from(arc.eval(0)), d = point_1.Point2.from(arc.eval(1));
            if (!point_1.Point2.areClose(a, z0, tolerance)) {
                sink.lineTo(a.x, a.y);
                z0 = a;
            }
            if (arc.isStraight()) {
                if (!point_1.Point2.areClose(d, z0, tolerance)) {
                    sink.lineTo(d.x, d.y);
                    z0 = d;
                }
            }
            else {
                const d0 = arc.derivative(0), d1 = arc.derivative(1);
                const b = a.addScale(1 / 3, d0), c = d.addScale(-1 / 3, d1);
                sink.cubicTo(b.x, b.y, c.x, c.y, d.x, d.y);
                z0 = d;
            }
        }
    }
    sink.endShape();
}
exports.transferBezArcShape = transferBezArcShape;
function transferGenericShape(shape, sink, tolerance = 1 / 16) {
    sink.beginShape();
    for (const contour of shape) {
        if (!contour.length)
            continue;
        let z0 = point_1.Point2.from(contour[0].eval(0));
        sink.moveTo(z0.x, z0.y);
        for (const arc of contour) {
            const a = point_1.Point2.from(arc.eval(0)), d = point_1.Point2.from(arc.eval(1));
            if (!point_1.Point2.areClose(a, z0, tolerance)) {
                sink.lineTo(a.x, a.y);
                z0 = a;
            }
            if (arc instanceof derivable_1.Arcs.StraightSegment) {
                if (!point_1.Point2.areClose(d, z0, tolerance)) {
                    sink.lineTo(d.x, d.y);
                    z0 = d;
                }
            }
            else {
                sink.arcTo(arc, d.x, d.y);
                z0 = d;
            }
        }
    }
    sink.endShape();
}
exports.transferGenericShape = transferGenericShape;
function transferGenericShapeAsBezier(shape, sink, tolerance = 1 / 16) {
    return transferBezArcShape((0, shape_to_bez3_1.convertShapeToBez3)(shape, tolerance), sink, tolerance);
}
exports.transferGenericShapeAsBezier = transferGenericShapeAsBezier;
