export interface Read<T, A extends unknown[] = []> {
    read(view: BinaryView, ...args: A): T;
}
export declare function Read<T, A extends unknown[] = []>(proc: (view: BinaryView, ...args: A) => T): Read<T, A>;
export interface Sized {
    readonly size: number;
}
export interface Ranged {
    readonly min: number;
    readonly max: number;
}
export declare class BinaryView {
    protected readonly buffer: Buffer;
    displace: number;
    cursor: number;
    constructor(buffer: Buffer, displace?: number, cursor?: number);
    get sourceBufferSize(): number;
    next<T, A extends unknown[], AR extends A>(inst: Read<T, A>, ...args: AR): T;
    array<T, A extends unknown[], AR extends A>(count: number, inst: Read<T, A>, ...args: AR): T[];
    /** Create a new BinaryView using an offset relative to current view's displacement. */
    lift(offset: number): BinaryView;
    /** Create a new BinaryView using an offset relative to the current cursor. */
    liftRelative(offset: number): BinaryView;
    uint8(): number;
    uint16(): number;
    uint32(): number;
    int8(): number;
    int16(): number;
    int32(): number;
    ptr16(): BinaryView;
    ptr16Nullable(): BinaryView | null;
    ptr32(): BinaryView;
    ptr32Nullable(): BinaryView | null;
    bytes(length: number): Buffer<ArrayBuffer>;
    repeat(count: number): IterableIterator<[BinaryView, number]>;
}
//# sourceMappingURL=binary-view.d.ts.map