"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DesignSpaceUnifier = exports.DesignUnifierSession = void 0;
exports.unifyDesignSpacesImpl = unifyDesignSpacesImpl;
exports.unifyDesignSpaces = unifyDesignSpaces;
const Ot = require("@ot-builder/ot");
const Rectify = require("@ot-builder/rectify");
const point_rectifier_1 = require("../point-rectifier");
const value_process_1 = require("./value-process");
class DesignUnifierSession {
    constructor() {
        this.am = new value_process_1.DimMapper();
        this.vp = new value_process_1.ValueProcessor(new value_process_1.MasterProcessor(this.am));
    }
}
exports.DesignUnifierSession = DesignUnifierSession;
class DesignSpaceUnifier {
    constructor(session, fvarRef, fvarCur) {
        this.session = session;
        this.addedAxes = [];
        if (fvarRef.axes.length !== fvarCur.axes.length) {
            throw new Error("Fvar axes count mismatch");
        }
        for (let aid = 0; aid < fvarCur.axes.length; aid++) {
            const curDim = fvarCur.axes[aid].dim;
            const refDim = fvarRef.axes[aid].dim;
            if (refDim.tag !== curDim.tag ||
                refDim.min !== curDim.min ||
                refDim.default !== curDim.default ||
                refDim.max !== curDim.max) {
                throw new Error("Axis dimension incompatible");
            }
            session.am.alias(fvarCur.axes[aid].dim, fvarRef.axes[aid].dim);
        }
    }
    dim(d) {
        return this.session.am.reverse(this.session.am.put(d));
    }
    axis(a) {
        return new Ot.Fvar.Axis(this.dim(a.dim), a.axisNameID, a.flags);
    }
    coord(v) {
        return this.session.vp.toUniqueValue(v);
    }
    cv(v) {
        return this.session.vp.toUniqueValue(v);
    }
}
exports.DesignSpaceUnifier = DesignSpaceUnifier;
function unifyDesignSpacesImpl(session, ref, demand) {
    const fvar0 = ref.fvar;
    const fvarI = demand.fvar;
    if (fvar0 && fvarI) {
        const du = new DesignSpaceUnifier(session, fvar0, fvarI);
        Rectify.inPlaceRectifyFont({ glyphRef: g => g }, du, du, new point_rectifier_1.StdPointAttachRectifier(), demand);
    }
    else if (fvarI) {
        throw new Error("Cannot unify variable font with static font");
    }
}
function unifyDesignSpaces(fonts) {
    if (fonts.length < 2)
        return;
    const session = new DesignUnifierSession();
    const ref = fonts[0];
    for (let fid = 1; fid < fonts.length; fid++) {
        unifyDesignSpacesImpl(session, ref, fonts[fid]);
    }
}
//# sourceMappingURL=index.js.map