"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UvsEncodingCollector = exports.UvsEncodingEntry = exports.UnicodeEncodingCollector = void 0;
class UnicodeEncodingCollector {
    constructor(encoding, gOrd, maxCodePoint) {
        this.encoding = encoding;
        this.gOrd = gOrd;
        this.maxCodePoint = maxCodePoint;
    }
    collect() {
        const results = [];
        for (const [code, glyph] of this.encoding.entries()) {
            if (code < 0 || code >= this.maxCodePoint)
                continue;
            const gid = this.gOrd.reverse(glyph);
            if (gid == null)
                continue;
            results.push([code, gid]);
        }
        results.sort((p, q) => p[0] - q[0]);
        return results;
    }
}
exports.UnicodeEncodingCollector = UnicodeEncodingCollector;
class UvsEncodingEntry {
    constructor(selector) {
        this.selector = selector;
        this.defaults = [];
        this.nonDefaults = [];
    }
    sort() {
        this.defaults.sort((a, b) => a - b);
        this.nonDefaults.sort((a, b) => a[0] - b[0]);
    }
}
exports.UvsEncodingEntry = UvsEncodingEntry;
class UvsEncodingCollector {
    constructor(encoding, defaults, gOrd) {
        this.encoding = encoding;
        this.defaults = defaults;
        this.gOrd = gOrd;
    }
    collect() {
        const m = new Map();
        for (const [code, selector, glyph] of this.encoding.entries()) {
            let ee = m.get(selector);
            if (!ee) {
                ee = new UvsEncodingEntry(selector);
                m.set(selector, ee);
            }
            const gid = this.gOrd.tryReverse(glyph);
            if (gid == null)
                continue;
            const isDefault = glyph === this.defaults.get(code);
            if (isDefault) {
                ee.defaults.push(code);
            }
            else {
                ee.nonDefaults.push([code, gid]);
            }
        }
        const a = Array.from(m.values());
        for (const ee of a)
            ee.sort();
        return a.sort((a, b) => a.selector - b.selector);
    }
}
exports.UvsEncodingCollector = UvsEncodingCollector;
//# sourceMappingURL=unicode-encoding-collector.js.map