"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findCrossIntersections = exports.findSelfIntersections = void 0;
const bez3_intersections_1 = require("./bez3-intersections");
class CSelfIntersectionSink {
    constructor(iArc, results) {
        this.iArc = iArc;
        this.results = results;
    }
    add(t) {
        this.results.push(this.iArc + t);
    }
}
function findSelfIntersections(shape) {
    let ans = [];
    for (let c = 0; c < shape.length; c++) {
        let contour = shape[c], results = [];
        for (let i = 0; i < contour.length; i++) {
            (0, bez3_intersections_1.bez3SelfIntersections)(contour[i], new CSelfIntersectionSink(i, results));
        }
        ans.push(results);
    }
    return ans;
}
exports.findSelfIntersections = findSelfIntersections;
class CCrossIntersectionSink {
    constructor(iArc1, iArc2, results1, results2) {
        this.iArc1 = iArc1;
        this.iArc2 = iArc2;
        this.results1 = results1;
        this.results2 = results2;
    }
    add(t1, t2) {
        this.results1.push(this.iArc1 + t1);
        this.results2.push(this.iArc2 + t2);
    }
}
function findCrossIntersections(shape1, shape2, i1, i2, sameShape) {
    for (let c1 = 0; c1 < shape1.length; c1++) {
        const contour1 = shape1[c1];
        for (let a1 = 0; a1 < contour1.length; a1++) {
            for (let c2 = 0; c2 < shape2.length; c2++) {
                const contour2 = shape2[c2];
                for (let a2 = 0; a2 < contour2.length; a2++) {
                    if (sameShape && (c1 > c2 || (c1 === c2 && a1 >= a2)))
                        continue;
                    const sink = new CCrossIntersectionSink(a1, a2, i1[c1], i2[c2]);
                    (0, bez3_intersections_1.bez3Intersections)(contour1[a1], contour2[a2], sink);
                }
            }
        }
    }
}
exports.findCrossIntersections = findCrossIntersections;
