import { Reporter } from "./index";
export default class ConsoleReporter implements Reporter {
    verbosity: number;
    private spinner;
    private text;
    private columns;
    private activeTargets;
    private finishedTargets;
    private reportedErrors;
    private targetHalts;
    constructor(verbosity: number, parent?: ConsoleReporter);
    start(): void;
    private beforeOutput;
    private afterOutput;
    end(wrong?: boolean): void;
    private progressMessage;
    targetStart(id: string): void;
    targetSkip(id: string): void;
    targetEnd(id: string): void;
    systemError(err: Error): void;
    targetError(id: string, err: Error): void;
    targetHalt(name: string): void;
    targetUnHalt(name: string): void;
    rawLog(...line: any[]): void;
    redirectStdout(line: string | Buffer): void;
    redirectStderr(line: string | Buffer): void;
    private directive;
    private extractFirstLine;
    private getStyle;
    actions(commands: string[][], style?: string): void;
    private directiveLogging;
    debug(...line: any[]): void;
    info(...line: any[]): void;
    echo(...line: any[]): void;
    note(...line: any[]): void;
    warn(...line: any[]): void;
    success(...line: any[]): void;
    fail(...line: any[]): void;
    error(...line: any[]): void;
    fatal(...line: any[]): void;
}
