---
date: 2026-02-19
section: 1
title: GO-ENV
header: Go programming tools and commands
footer: Go 1.26
---

# NAME

go-env - print Go environment information

# SYNOPSIS

**go env** \[**-json**\] \[**-changed**\] \[**-u**\] \[**-w**\] \[*var ...*\]

# DESCRIPTION

Env prints Go environment information.

By default env prints information as a shell script (on Windows, a batch
file). If one or more variable names is given as arguments, env prints
the value of each named variable on its own line.

The **-json** flag prints the environment in JSON format instead of as a
shell script.

The **-u** flag requires one or more arguments and unsets the default
setting for the named environment variables, if one has been set with
'go env **-w**'.

The **-w** flag requires one or more arguments of the form NAME=VALUE
and changes the default settings of the named environment variables to
the given values.

The **-changed** flag prints only those settings whose effective value
differs from the default value that would be obtained in an empty
environment with no prior uses of the **-w** flag.

For more about environment variables, see 'go help environment'.

# AUTHOR

This manual page was created using help2man and afterwards updating the
output. It is maintained by the Debian Go Compiler Team
\<team+go-compiler@tracker.debian.org\> for the Debian project (and may
be used by others).
