// Code generated by smithy-go-codegen DO NOT EDIT.

package mpa

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mpa/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns details for an approval session. For more information, see [Session] in the
// Multi-party approval User Guide.
//
// [Session]: https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
func (c *Client) GetSession(ctx context.Context, params *GetSessionInput, optFns ...func(*Options)) (*GetSessionOutput, error) {
	if params == nil {
		params = &GetSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSession", params, optFns, c.addOperationGetSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSessionInput struct {

	// Amazon Resource Name (ARN) for the session.
	//
	// This member is required.
	SessionArn *string

	noSmithyDocumentSerde
}

type GetSessionOutput struct {

	// Strategy for executing the protected operation. AUTO_COMPLETION_UPON_APPROVAL
	// means the operation is automatically executed using the requester's permissions,
	// if approved.
	ActionCompletionStrategy types.ActionCompletionStrategy

	// Name of the protected operation.
	ActionName *string

	// An ApprovalStrategyResponse object. Contains details for how the team grants
	// approval
	ApprovalStrategy types.ApprovalStrategyResponse

	// Amazon Resource Name (ARN) for the approval team.
	ApprovalTeamArn *string

	// Name of the approval team.
	ApprovalTeamName *string

	// An array of GetSessionResponseApproverResponse objects. Contains details for
	// approver responses in the session.
	ApproverResponses []types.GetSessionResponseApproverResponse

	// Timestamp when the session completed.
	CompletionTime *time.Time

	// Description for the session.
	Description *string

	// Status for the protected operation. For example, if the operation is PENDING .
	ExecutionStatus types.SessionExecutionStatus

	// Timestamp when the session will expire.
	ExpirationTime *time.Time

	// Timestamp when the session was initiated.
	InitiationTime *time.Time

	// Metadata for the session.
	Metadata map[string]string

	// Total number of approvers in the session.
	NumberOfApprovers *int32

	// Amazon Resource Name (ARN) for the protected operation.
	ProtectedResourceArn *string

	// ID for the account that made the operation request.
	RequesterAccountId *string

	// Message from the account that made the operation request
	RequesterComment *string

	// [IAM principal] that made the operation request.
	//
	// [IAM principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request
	RequesterPrincipalArn *string

	// Amazon Web Services Region where the operation request originated.
	RequesterRegion *string

	// [Service principal] for the service associated with the protected operation.
	//
	// [Service principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services
	RequesterServicePrincipal *string

	// Amazon Resource Name (ARN) for the session.
	SessionArn *string

	// Status for the session. For example, if the team has approved the requested
	// operation.
	Status types.SessionStatus

	// Status code of the session.
	StatusCode types.SessionStatusCode

	// Message describing the status for session.
	StatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSession",
	}
}
