//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdns

// ARecord - An A record.
type ARecord struct {
	// The IPv4 address of this A record.
	IPv4Address *string `json:"ipv4Address,omitempty"`
}

// AaaaRecord - An AAAA record.
type AaaaRecord struct {
	// The IPv6 address of this AAAA record.
	IPv6Address *string `json:"ipv6Address,omitempty"`
}

// CnameRecord - A CNAME record.
type CnameRecord struct {
	// The canonical name for this CNAME record.
	Cname *string `json:"cname,omitempty"`
}

// MxRecord - An MX record.
type MxRecord struct {
	// The domain name of the mail host for this MX record.
	Exchange *string `json:"exchange,omitempty"`

	// The preference value for this MX record.
	Preference *int32 `json:"preference,omitempty"`
}

// NsRecord - An NS record.
type NsRecord struct {
	// The name server name for this NS record.
	Nsdname *string `json:"nsdname,omitempty"`
}

// PtrRecord - A PTR record.
type PtrRecord struct {
	// The PTR target domain name for this PTR record.
	Ptrdname *string `json:"ptrdname,omitempty"`
}

// RecordSet - Describes a DNS record set (a collection of DNS records with the same name and type).
type RecordSet struct {
	// The etag of the record set.
	Etag *string `json:"etag,omitempty"`

	// The ID of the record set.
	ID *string `json:"id,omitempty"`

	// The name of the record set.
	Name *string `json:"name,omitempty"`

	// The properties of the record set.
	Properties *RecordSetProperties `json:"properties,omitempty"`

	// The type of the record set.
	Type *string `json:"type,omitempty"`
}

// RecordSetListResult - The response to a record set List operation.
type RecordSetListResult struct {
	// The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Information about the record sets in the response.
	Value []*RecordSet `json:"value,omitempty"`
}

// RecordSetProperties - Represents the properties of the records in the record set.
type RecordSetProperties struct {
	// The list of A records in the record set.
	ARecords []*ARecord `json:"ARecords,omitempty"`

	// The list of AAAA records in the record set.
	AaaaRecords []*AaaaRecord `json:"AAAARecords,omitempty"`

	// The CNAME record in the record set.
	CnameRecord *CnameRecord `json:"CNAMERecord,omitempty"`

	// The metadata attached to the record set.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// The list of MX records in the record set.
	MxRecords []*MxRecord `json:"MXRecords,omitempty"`

	// The list of NS records in the record set.
	NsRecords []*NsRecord `json:"NSRecords,omitempty"`

	// The list of PTR records in the record set.
	PtrRecords []*PtrRecord `json:"PTRRecords,omitempty"`

	// The SOA record in the record set.
	SoaRecord *SoaRecord `json:"SOARecord,omitempty"`

	// The list of SRV records in the record set.
	SrvRecords []*SrvRecord `json:"SRVRecords,omitempty"`

	// The TTL (time-to-live) of the records in the record set.
	TTL *int64 `json:"TTL,omitempty"`

	// The list of TXT records in the record set.
	TxtRecords []*TxtRecord `json:"TXTRecords,omitempty"`

	// READ-ONLY; Fully qualified domain name of the record set.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// RecordSetUpdateParameters - Parameters supplied to update a record set.
type RecordSetUpdateParameters struct {
	// Specifies information about the record set being updated.
	RecordSet *RecordSet `json:"RecordSet,omitempty"`
}

// RecordSetsClientCreateOrUpdateOptions contains the optional parameters for the RecordSetsClient.CreateOrUpdate method.
type RecordSetsClientCreateOrUpdateOptions struct {
	// The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value
	// to prevent accidentally overwriting any concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be
	// ignored.
	IfNoneMatch *string
}

// RecordSetsClientDeleteOptions contains the optional parameters for the RecordSetsClient.Delete method.
type RecordSetsClientDeleteOptions struct {
	// The etag of the record set. Omit this value to always delete the current record set. Specify the last-seen etag value to
	// prevent accidentally deleting any concurrent changes.
	IfMatch *string
}

// RecordSetsClientGetOptions contains the optional parameters for the RecordSetsClient.Get method.
type RecordSetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecordSetsClientListByDNSZoneOptions contains the optional parameters for the RecordSetsClient.NewListByDNSZonePager method.
type RecordSetsClientListByDNSZoneOptions struct {
	// The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is
	// specified, Enumeration will return only records that end with .
	Recordsetnamesuffix *string
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// RecordSetsClientListByTypeOptions contains the optional parameters for the RecordSetsClient.NewListByTypePager method.
type RecordSetsClientListByTypeOptions struct {
	// The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is
	// specified, Enumeration will return only records that end with .
	Recordsetnamesuffix *string
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// RecordSetsClientUpdateOptions contains the optional parameters for the RecordSetsClient.Update method.
type RecordSetsClientUpdateOptions struct {
	// The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SoaRecord - An SOA record.
type SoaRecord struct {
	// The email contact for this SOA record.
	Email *string `json:"email,omitempty"`

	// The expire time for this SOA record.
	ExpireTime *int64 `json:"expireTime,omitempty"`

	// The domain name of the authoritative name server for this SOA record.
	Host *string `json:"host,omitempty"`

	// The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
	MinimumTTL *int64 `json:"minimumTTL,omitempty"`

	// The refresh value for this SOA record.
	RefreshTime *int64 `json:"refreshTime,omitempty"`

	// The retry time for this SOA record.
	RetryTime *int64 `json:"retryTime,omitempty"`

	// The serial number for this SOA record.
	SerialNumber *int64 `json:"serialNumber,omitempty"`
}

// SrvRecord - An SRV record.
type SrvRecord struct {
	// The port value for this SRV record.
	Port *int32 `json:"port,omitempty"`

	// The priority value for this SRV record.
	Priority *int32 `json:"priority,omitempty"`

	// The target domain name for this SRV record.
	Target *string `json:"target,omitempty"`

	// The weight value for this SRV record.
	Weight *int32 `json:"weight,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TxtRecord - A TXT record.
type TxtRecord struct {
	// The text value of this TXT record.
	Value []*string `json:"value,omitempty"`
}

// Zone - Describes a DNS zone.
type Zone struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The etag of the zone.
	Etag *string `json:"etag,omitempty"`

	// The properties of the zone.
	Properties *ZoneProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ZoneDeleteResult - The response to a Zone Delete operation.
type ZoneDeleteResult struct {
	// Users can perform a Get on Azure-AsyncOperation to get the status of their delete Zone operations.
	AzureAsyncOperation *string          `json:"azureAsyncOperation,omitempty"`
	RequestID           *string          `json:"requestId,omitempty"`
	Status              *OperationStatus `json:"status,omitempty"`
	StatusCode          *HTTPStatusCode  `json:"statusCode,omitempty"`
}

// ZoneListResult - The response to a Zone List or ListAll operation.
type ZoneListResult struct {
	// The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Information about the DNS zones.
	Value []*Zone `json:"value,omitempty"`
}

// ZoneProperties - Represents the properties of the zone.
type ZoneProperties struct {
	// The maximum number of record sets that can be created in this DNS zone. This is a read-only property and any attempt to
	// set this value will be ignored.
	MaxNumberOfRecordSets *int64 `json:"maxNumberOfRecordSets,omitempty"`

	// The current number of record sets in this DNS zone. This is a read-only property and any attempt to set this value will
	// be ignored.
	NumberOfRecordSets *int64 `json:"numberOfRecordSets,omitempty"`

	// The type of this DNS zone (Public or Private).
	ZoneType *ZoneType `json:"zoneType,omitempty"`

	// READ-ONLY; The maximum number of records per record set that can be created in this DNS zone. This is a read-only property
	// and any attempt to set this value will be ignored.
	MaxNumberOfRecordsPerRecordSet *int64 `json:"maxNumberOfRecordsPerRecordSet,omitempty" azure:"ro"`

	// READ-ONLY; The name servers for this DNS zone. This is a read-only property and any attempt to set this value will be ignored.
	NameServers []*string `json:"nameServers,omitempty" azure:"ro"`
}

// ZonesClientBeginDeleteOptions contains the optional parameters for the ZonesClient.BeginDelete method.
type ZonesClientBeginDeleteOptions struct {
	// The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent
	// accidentally deleting any concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ZonesClientCreateOrUpdateOptions contains the optional parameters for the ZonesClient.CreateOrUpdate method.
type ZonesClientCreateOrUpdateOptions struct {
	// The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent
	// accidentally overwriting any concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new DNS zone to be created, but to prevent updating an existing zone. Other values will be ignored.
	IfNoneMatch *string
}

// ZonesClientGetOptions contains the optional parameters for the ZonesClient.Get method.
type ZonesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ZonesClientListByResourceGroupOptions contains the optional parameters for the ZonesClient.NewListByResourceGroupPager
// method.
type ZonesClientListByResourceGroupOptions struct {
	// The maximum number of record sets to return. If not specified, returns up to 100 record sets.
	Top *int32
}

// ZonesClientListOptions contains the optional parameters for the ZonesClient.NewListPager method.
type ZonesClientListOptions struct {
	// The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
	Top *int32
}
