//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// WebSiteManagementServer is a fake server for instances of the armappservice.WebSiteManagementClient type.
type WebSiteManagementServer struct {
	// CheckNameAvailability is the fake for method WebSiteManagementClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, request armappservice.ResourceNameAvailabilityRequest, options *armappservice.WebSiteManagementClientCheckNameAvailabilityOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// GetPublishingUser is the fake for method WebSiteManagementClient.GetPublishingUser
	// HTTP status codes to indicate success: http.StatusOK
	GetPublishingUser func(ctx context.Context, options *armappservice.WebSiteManagementClientGetPublishingUserOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientGetPublishingUserResponse], errResp azfake.ErrorResponder)

	// GetSourceControl is the fake for method WebSiteManagementClient.GetSourceControl
	// HTTP status codes to indicate success: http.StatusOK
	GetSourceControl func(ctx context.Context, sourceControlType string, options *armappservice.WebSiteManagementClientGetSourceControlOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientGetSourceControlResponse], errResp azfake.ErrorResponder)

	// GetSubscriptionDeploymentLocations is the fake for method WebSiteManagementClient.GetSubscriptionDeploymentLocations
	// HTTP status codes to indicate success: http.StatusOK
	GetSubscriptionDeploymentLocations func(ctx context.Context, options *armappservice.WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse], errResp azfake.ErrorResponder)

	// NewListAseRegionsPager is the fake for method WebSiteManagementClient.NewListAseRegionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAseRegionsPager func(options *armappservice.WebSiteManagementClientListAseRegionsOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListAseRegionsResponse])

	// NewListBillingMetersPager is the fake for method WebSiteManagementClient.NewListBillingMetersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBillingMetersPager func(options *armappservice.WebSiteManagementClientListBillingMetersOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListBillingMetersResponse])

	// NewListCustomHostNameSitesPager is the fake for method WebSiteManagementClient.NewListCustomHostNameSitesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCustomHostNameSitesPager func(options *armappservice.WebSiteManagementClientListCustomHostNameSitesOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListCustomHostNameSitesResponse])

	// NewListGeoRegionsPager is the fake for method WebSiteManagementClient.NewListGeoRegionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGeoRegionsPager func(options *armappservice.WebSiteManagementClientListGeoRegionsOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListGeoRegionsResponse])

	// NewListPremierAddOnOffersPager is the fake for method WebSiteManagementClient.NewListPremierAddOnOffersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPremierAddOnOffersPager func(options *armappservice.WebSiteManagementClientListPremierAddOnOffersOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListPremierAddOnOffersResponse])

	// ListSKUs is the fake for method WebSiteManagementClient.ListSKUs
	// HTTP status codes to indicate success: http.StatusOK
	ListSKUs func(ctx context.Context, options *armappservice.WebSiteManagementClientListSKUsOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientListSKUsResponse], errResp azfake.ErrorResponder)

	// NewListSiteIdentifiersAssignedToHostNamePager is the fake for method WebSiteManagementClient.NewListSiteIdentifiersAssignedToHostNamePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSiteIdentifiersAssignedToHostNamePager func(nameIdentifier armappservice.NameIdentifier, options *armappservice.WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse])

	// NewListSourceControlsPager is the fake for method WebSiteManagementClient.NewListSourceControlsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSourceControlsPager func(options *armappservice.WebSiteManagementClientListSourceControlsOptions) (resp azfake.PagerResponder[armappservice.WebSiteManagementClientListSourceControlsResponse])

	// Move is the fake for method WebSiteManagementClient.Move
	// HTTP status codes to indicate success: http.StatusNoContent
	Move func(ctx context.Context, resourceGroupName string, moveResourceEnvelope armappservice.CsmMoveResourceEnvelope, options *armappservice.WebSiteManagementClientMoveOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientMoveResponse], errResp azfake.ErrorResponder)

	// UpdatePublishingUser is the fake for method WebSiteManagementClient.UpdatePublishingUser
	// HTTP status codes to indicate success: http.StatusOK
	UpdatePublishingUser func(ctx context.Context, userDetails armappservice.User, options *armappservice.WebSiteManagementClientUpdatePublishingUserOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientUpdatePublishingUserResponse], errResp azfake.ErrorResponder)

	// UpdateSourceControl is the fake for method WebSiteManagementClient.UpdateSourceControl
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSourceControl func(ctx context.Context, sourceControlType string, requestMessage armappservice.SourceControl, options *armappservice.WebSiteManagementClientUpdateSourceControlOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientUpdateSourceControlResponse], errResp azfake.ErrorResponder)

	// Validate is the fake for method WebSiteManagementClient.Validate
	// HTTP status codes to indicate success: http.StatusOK
	Validate func(ctx context.Context, resourceGroupName string, validateRequest armappservice.ValidateRequest, options *armappservice.WebSiteManagementClientValidateOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientValidateResponse], errResp azfake.ErrorResponder)

	// ValidateMove is the fake for method WebSiteManagementClient.ValidateMove
	// HTTP status codes to indicate success: http.StatusNoContent
	ValidateMove func(ctx context.Context, resourceGroupName string, moveResourceEnvelope armappservice.CsmMoveResourceEnvelope, options *armappservice.WebSiteManagementClientValidateMoveOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientValidateMoveResponse], errResp azfake.ErrorResponder)

	// VerifyHostingEnvironmentVnet is the fake for method WebSiteManagementClient.VerifyHostingEnvironmentVnet
	// HTTP status codes to indicate success: http.StatusOK
	VerifyHostingEnvironmentVnet func(ctx context.Context, parameters armappservice.VnetParameters, options *armappservice.WebSiteManagementClientVerifyHostingEnvironmentVnetOptions) (resp azfake.Responder[armappservice.WebSiteManagementClientVerifyHostingEnvironmentVnetResponse], errResp azfake.ErrorResponder)
}

// NewWebSiteManagementServerTransport creates a new instance of WebSiteManagementServerTransport with the provided implementation.
// The returned WebSiteManagementServerTransport instance is connected to an instance of armappservice.WebSiteManagementClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWebSiteManagementServerTransport(srv *WebSiteManagementServer) *WebSiteManagementServerTransport {
	return &WebSiteManagementServerTransport{
		srv:                             srv,
		newListAseRegionsPager:          newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListAseRegionsResponse]](),
		newListBillingMetersPager:       newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListBillingMetersResponse]](),
		newListCustomHostNameSitesPager: newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListCustomHostNameSitesResponse]](),
		newListGeoRegionsPager:          newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListGeoRegionsResponse]](),
		newListPremierAddOnOffersPager:  newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListPremierAddOnOffersResponse]](),
		newListSiteIdentifiersAssignedToHostNamePager: newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse]](),
		newListSourceControlsPager:                    newTracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListSourceControlsResponse]](),
	}
}

// WebSiteManagementServerTransport connects instances of armappservice.WebSiteManagementClient to instances of WebSiteManagementServer.
// Don't use this type directly, use NewWebSiteManagementServerTransport instead.
type WebSiteManagementServerTransport struct {
	srv                                           *WebSiteManagementServer
	newListAseRegionsPager                        *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListAseRegionsResponse]]
	newListBillingMetersPager                     *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListBillingMetersResponse]]
	newListCustomHostNameSitesPager               *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListCustomHostNameSitesResponse]]
	newListGeoRegionsPager                        *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListGeoRegionsResponse]]
	newListPremierAddOnOffersPager                *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListPremierAddOnOffersResponse]]
	newListSiteIdentifiersAssignedToHostNamePager *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse]]
	newListSourceControlsPager                    *tracker[azfake.PagerResponder[armappservice.WebSiteManagementClientListSourceControlsResponse]]
}

// Do implements the policy.Transporter interface for WebSiteManagementServerTransport.
func (w *WebSiteManagementServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WebSiteManagementClient.CheckNameAvailability":
		resp, err = w.dispatchCheckNameAvailability(req)
	case "WebSiteManagementClient.GetPublishingUser":
		resp, err = w.dispatchGetPublishingUser(req)
	case "WebSiteManagementClient.GetSourceControl":
		resp, err = w.dispatchGetSourceControl(req)
	case "WebSiteManagementClient.GetSubscriptionDeploymentLocations":
		resp, err = w.dispatchGetSubscriptionDeploymentLocations(req)
	case "WebSiteManagementClient.NewListAseRegionsPager":
		resp, err = w.dispatchNewListAseRegionsPager(req)
	case "WebSiteManagementClient.NewListBillingMetersPager":
		resp, err = w.dispatchNewListBillingMetersPager(req)
	case "WebSiteManagementClient.NewListCustomHostNameSitesPager":
		resp, err = w.dispatchNewListCustomHostNameSitesPager(req)
	case "WebSiteManagementClient.NewListGeoRegionsPager":
		resp, err = w.dispatchNewListGeoRegionsPager(req)
	case "WebSiteManagementClient.NewListPremierAddOnOffersPager":
		resp, err = w.dispatchNewListPremierAddOnOffersPager(req)
	case "WebSiteManagementClient.ListSKUs":
		resp, err = w.dispatchListSKUs(req)
	case "WebSiteManagementClient.NewListSiteIdentifiersAssignedToHostNamePager":
		resp, err = w.dispatchNewListSiteIdentifiersAssignedToHostNamePager(req)
	case "WebSiteManagementClient.NewListSourceControlsPager":
		resp, err = w.dispatchNewListSourceControlsPager(req)
	case "WebSiteManagementClient.Move":
		resp, err = w.dispatchMove(req)
	case "WebSiteManagementClient.UpdatePublishingUser":
		resp, err = w.dispatchUpdatePublishingUser(req)
	case "WebSiteManagementClient.UpdateSourceControl":
		resp, err = w.dispatchUpdateSourceControl(req)
	case "WebSiteManagementClient.Validate":
		resp, err = w.dispatchValidate(req)
	case "WebSiteManagementClient.ValidateMove":
		resp, err = w.dispatchValidateMove(req)
	case "WebSiteManagementClient.VerifyHostingEnvironmentVnet":
		resp, err = w.dispatchVerifyHostingEnvironmentVnet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if w.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/checknameavailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.ResourceNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CheckNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceNameAvailability, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchGetPublishingUser(req *http.Request) (*http.Response, error) {
	if w.srv.GetPublishingUser == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPublishingUser not implemented")}
	}
	respr, errRespr := w.srv.GetPublishingUser(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).User, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchGetSourceControl(req *http.Request) (*http.Response, error) {
	if w.srv.GetSourceControl == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSourceControl not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Web/sourcecontrols/(?P<sourceControlType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	sourceControlTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlType")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSourceControl(req.Context(), sourceControlTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SourceControl, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchGetSubscriptionDeploymentLocations(req *http.Request) (*http.Response, error) {
	if w.srv.GetSubscriptionDeploymentLocations == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSubscriptionDeploymentLocations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/deploymentLocations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := w.srv.GetSubscriptionDeploymentLocations(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentLocations, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListAseRegionsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListAseRegionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAseRegionsPager not implemented")}
	}
	newListAseRegionsPager := w.newListAseRegionsPager.get(req)
	if newListAseRegionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/aseRegions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListAseRegionsPager(nil)
		newListAseRegionsPager = &resp
		w.newListAseRegionsPager.add(req, newListAseRegionsPager)
		server.PagerResponderInjectNextLinks(newListAseRegionsPager, req, func(page *armappservice.WebSiteManagementClientListAseRegionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAseRegionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListAseRegionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAseRegionsPager) {
		w.newListAseRegionsPager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListBillingMetersPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListBillingMetersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBillingMetersPager not implemented")}
	}
	newListBillingMetersPager := w.newListBillingMetersPager.get(req)
	if newListBillingMetersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/billingMeters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingLocationUnescaped, err := url.QueryUnescape(qp.Get("billingLocation"))
		if err != nil {
			return nil, err
		}
		billingLocationParam := getOptional(billingLocationUnescaped)
		oSTypeUnescaped, err := url.QueryUnescape(qp.Get("osType"))
		if err != nil {
			return nil, err
		}
		oSTypeParam := getOptional(oSTypeUnescaped)
		var options *armappservice.WebSiteManagementClientListBillingMetersOptions
		if billingLocationParam != nil || oSTypeParam != nil {
			options = &armappservice.WebSiteManagementClientListBillingMetersOptions{
				BillingLocation: billingLocationParam,
				OSType:          oSTypeParam,
			}
		}
		resp := w.srv.NewListBillingMetersPager(options)
		newListBillingMetersPager = &resp
		w.newListBillingMetersPager.add(req, newListBillingMetersPager)
		server.PagerResponderInjectNextLinks(newListBillingMetersPager, req, func(page *armappservice.WebSiteManagementClientListBillingMetersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBillingMetersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListBillingMetersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBillingMetersPager) {
		w.newListBillingMetersPager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListCustomHostNameSitesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListCustomHostNameSitesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCustomHostNameSitesPager not implemented")}
	}
	newListCustomHostNameSitesPager := w.newListCustomHostNameSitesPager.get(req)
	if newListCustomHostNameSitesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/customhostnameSites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		hostnameUnescaped, err := url.QueryUnescape(qp.Get("hostname"))
		if err != nil {
			return nil, err
		}
		hostnameParam := getOptional(hostnameUnescaped)
		var options *armappservice.WebSiteManagementClientListCustomHostNameSitesOptions
		if hostnameParam != nil {
			options = &armappservice.WebSiteManagementClientListCustomHostNameSitesOptions{
				Hostname: hostnameParam,
			}
		}
		resp := w.srv.NewListCustomHostNameSitesPager(options)
		newListCustomHostNameSitesPager = &resp
		w.newListCustomHostNameSitesPager.add(req, newListCustomHostNameSitesPager)
		server.PagerResponderInjectNextLinks(newListCustomHostNameSitesPager, req, func(page *armappservice.WebSiteManagementClientListCustomHostNameSitesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCustomHostNameSitesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListCustomHostNameSitesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCustomHostNameSitesPager) {
		w.newListCustomHostNameSitesPager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListGeoRegionsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListGeoRegionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGeoRegionsPager not implemented")}
	}
	newListGeoRegionsPager := w.newListGeoRegionsPager.get(req)
	if newListGeoRegionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/geoRegions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		sKUUnescaped, err := url.QueryUnescape(qp.Get("sku"))
		if err != nil {
			return nil, err
		}
		sKUParam := getOptional(armappservice.SKUName(sKUUnescaped))
		linuxWorkersEnabledUnescaped, err := url.QueryUnescape(qp.Get("linuxWorkersEnabled"))
		if err != nil {
			return nil, err
		}
		linuxWorkersEnabledParam, err := parseOptional(linuxWorkersEnabledUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		xenonWorkersEnabledUnescaped, err := url.QueryUnescape(qp.Get("xenonWorkersEnabled"))
		if err != nil {
			return nil, err
		}
		xenonWorkersEnabledParam, err := parseOptional(xenonWorkersEnabledUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		linuxDynamicWorkersEnabledUnescaped, err := url.QueryUnescape(qp.Get("linuxDynamicWorkersEnabled"))
		if err != nil {
			return nil, err
		}
		linuxDynamicWorkersEnabledParam, err := parseOptional(linuxDynamicWorkersEnabledUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armappservice.WebSiteManagementClientListGeoRegionsOptions
		if sKUParam != nil || linuxWorkersEnabledParam != nil || xenonWorkersEnabledParam != nil || linuxDynamicWorkersEnabledParam != nil {
			options = &armappservice.WebSiteManagementClientListGeoRegionsOptions{
				SKU:                        sKUParam,
				LinuxWorkersEnabled:        linuxWorkersEnabledParam,
				XenonWorkersEnabled:        xenonWorkersEnabledParam,
				LinuxDynamicWorkersEnabled: linuxDynamicWorkersEnabledParam,
			}
		}
		resp := w.srv.NewListGeoRegionsPager(options)
		newListGeoRegionsPager = &resp
		w.newListGeoRegionsPager.add(req, newListGeoRegionsPager)
		server.PagerResponderInjectNextLinks(newListGeoRegionsPager, req, func(page *armappservice.WebSiteManagementClientListGeoRegionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGeoRegionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListGeoRegionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGeoRegionsPager) {
		w.newListGeoRegionsPager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListPremierAddOnOffersPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPremierAddOnOffersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPremierAddOnOffersPager not implemented")}
	}
	newListPremierAddOnOffersPager := w.newListPremierAddOnOffersPager.get(req)
	if newListPremierAddOnOffersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/premieraddonoffers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListPremierAddOnOffersPager(nil)
		newListPremierAddOnOffersPager = &resp
		w.newListPremierAddOnOffersPager.add(req, newListPremierAddOnOffersPager)
		server.PagerResponderInjectNextLinks(newListPremierAddOnOffersPager, req, func(page *armappservice.WebSiteManagementClientListPremierAddOnOffersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPremierAddOnOffersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPremierAddOnOffersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPremierAddOnOffersPager) {
		w.newListPremierAddOnOffersPager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchListSKUs(req *http.Request) (*http.Response, error) {
	if w.srv.ListSKUs == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSKUs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/skus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := w.srv.ListSKUs(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SKUInfos, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListSiteIdentifiersAssignedToHostNamePager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSiteIdentifiersAssignedToHostNamePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSiteIdentifiersAssignedToHostNamePager not implemented")}
	}
	newListSiteIdentifiersAssignedToHostNamePager := w.newListSiteIdentifiersAssignedToHostNamePager.get(req)
	if newListSiteIdentifiersAssignedToHostNamePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/listSitesAssignedToHostName`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.NameIdentifier](req)
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSiteIdentifiersAssignedToHostNamePager(body, nil)
		newListSiteIdentifiersAssignedToHostNamePager = &resp
		w.newListSiteIdentifiersAssignedToHostNamePager.add(req, newListSiteIdentifiersAssignedToHostNamePager)
		server.PagerResponderInjectNextLinks(newListSiteIdentifiersAssignedToHostNamePager, req, func(page *armappservice.WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSiteIdentifiersAssignedToHostNamePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSiteIdentifiersAssignedToHostNamePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSiteIdentifiersAssignedToHostNamePager) {
		w.newListSiteIdentifiersAssignedToHostNamePager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchNewListSourceControlsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSourceControlsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSourceControlsPager not implemented")}
	}
	newListSourceControlsPager := w.newListSourceControlsPager.get(req)
	if newListSourceControlsPager == nil {
		resp := w.srv.NewListSourceControlsPager(nil)
		newListSourceControlsPager = &resp
		w.newListSourceControlsPager.add(req, newListSourceControlsPager)
		server.PagerResponderInjectNextLinks(newListSourceControlsPager, req, func(page *armappservice.WebSiteManagementClientListSourceControlsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSourceControlsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSourceControlsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSourceControlsPager) {
		w.newListSourceControlsPager.remove(req)
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchMove(req *http.Request) (*http.Response, error) {
	if w.srv.Move == nil {
		return nil, &nonRetriableError{errors.New("fake for method Move not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CsmMoveResourceEnvelope](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Move(req.Context(), resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchUpdatePublishingUser(req *http.Request) (*http.Response, error) {
	if w.srv.UpdatePublishingUser == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdatePublishingUser not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.User](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdatePublishingUser(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).User, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchUpdateSourceControl(req *http.Request) (*http.Response, error) {
	if w.srv.UpdateSourceControl == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSourceControl not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Web/sourcecontrols/(?P<sourceControlType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.SourceControl](req)
	if err != nil {
		return nil, err
	}
	sourceControlTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlType")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.UpdateSourceControl(req.Context(), sourceControlTypeParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SourceControl, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchValidate(req *http.Request) (*http.Response, error) {
	if w.srv.Validate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Validate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/validate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.ValidateRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Validate(req.Context(), resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidateResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchValidateMove(req *http.Request) (*http.Response, error) {
	if w.srv.ValidateMove == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateMove not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateMoveResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.CsmMoveResourceEnvelope](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.ValidateMove(req.Context(), resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WebSiteManagementServerTransport) dispatchVerifyHostingEnvironmentVnet(req *http.Request) (*http.Response, error) {
	if w.srv.VerifyHostingEnvironmentVnet == nil {
		return nil, &nonRetriableError{errors.New("fake for method VerifyHostingEnvironmentVnet not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/verifyHostingEnvironmentVnet`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappservice.VnetParameters](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.VerifyHostingEnvironmentVnet(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VnetValidationFailureDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
